/*
 *  Copyright (c) 1994/95 by Jaroslav Kysela (Perex soft)
 */

#define PCM_DEFAULT_RATE 8000

#define PCM_MODE_STEREO	0x0001		/* unset = MONO  , set = STEREO   */
#define PCM_MODE_U	0x0100		/* unset = signed, set = unsigned */
#define PCM_MODE_16	0x0200		/* unset = 8 bit , set = 16 bit   */
#define PCM_MODE_BIG	0x0400		/* big endian (16-bit mode) */
#define PCM_MODE_ULAW	0x0800
#define PCM_MODE_ALAW	0x1000
#define PCM_MODE_ADPCM	0x2000
#define PCM_MODE_TYPE	0xff00

#define PCM_FLG_NONE	0x0000
#define PCM_FLG_SLEEP	0x0001		/* channel is in sleep state - need wakeup */
#define PCM_FLG_ABORT	0x0002		/* user abort */

struct stru_pcm_buf {
  short dma;
  short flags;
  short used;
  int size;				/* size of one DMA buffer */
  short active;				/* active buffer for user */
  unsigned char *buf[ 2 ];
  int tsize[ 2 ];			/* transfer size */
};

/* pcm.c */

extern struct stru_pcm_buf pcm_playback;
extern struct stru_pcm_buf pcm_record;

extern unsigned int pcm_mode;
extern unsigned int pcm_format;
extern unsigned int pcm_rate;

int pcm_user_to_dma( char *buf, int count );
int pcm_dma_to_user( char *buf, int count );

/* gf1_pcm.c */

void gf1_init_to_dma( void );
void gf1_done_to_dma( void );
void gf1_init_from_dma( void );
void gf1_done_from_dma( void );

/* codec_pcm.c */

extern void codec_open( void );
extern void codec_close( void );
extern void codec_init_to_dma( void );
extern void codec_done_to_dma( void );
extern void codec_init_from_dma( void );
extern void codec_done_from_dma( void );

/* other things */

SLEEP_EXTERN( playback )
SLEEP_EXTERN( record )
