/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 *  Convert functions
 */

#include <asm/byteorder.h>
#include "libgus.h"
#include "libgus_local.h"

inline unsigned char get_unsigned_byte( unsigned char *ptr )
{
  return *ptr;
}

inline void put_unsigned_byte( unsigned char *ptr, unsigned char val )
{
  *ptr = val;
}

inline signed char get_signed_byte( unsigned char *ptr )
{
  return *(signed char *)ptr;
}

inline void put_signed_byte( unsigned char *ptr, signed char val )
{
  *(signed char *)ptr = val;
}

#ifdef __LITTLE_ENDIAN

inline signed short get_signed_word( unsigned char *ptr )
{
  return *(signed short *)ptr;
}

inline void put_signed_word( unsigned char *ptr, signed short val )
{
  *(signed short *)ptr = val;
}

inline unsigned short get_unsigned_word( unsigned char *ptr )
{
  return *(unsigned short *)ptr;
}

inline void put_unsigned_word( unsigned char *ptr, unsigned short val )
{
  *(unsigned short *)ptr = val;
}

#else

inline unsigned short get_signed_word( unsigned char *ptr )
{
  return (signed short)( *ptr + ( *( ptr + 1 ) << 8 );
}

inline void put_signed_word( unsigned char *ptr, signed short val )
{
  *ptr = (unsigned char)val;
  *(ptr + 1) = val >> 8;
}

inline unsigned short get_unsigned_word( unsigned char *ptr )
{
  return (signed short)( *ptr + ( *( ptr + 1 ) << 8 );
}

inline void put_unsigned_word( unsigned char *ptr, unsigned short val )
{
  *ptr = (unsigned char)val;
  *(ptr + 1) = val >> 8;
}

#endif

/*
 *  EXPORTED FUNCTIONS
 */

/*
 *  ----------------- delta
 */

void gus_convert_delta( unsigned int type, unsigned char *dest,
			unsigned char *src, size_t size )
{
  if ( !( type & GUS_WAVE_DELTA ) ) return;
  if ( type & GUS_WAVE_16BIT )
    {
      if ( type & GUS_WAVE_UNSIGNED )	/* unsigned */
        {
          unsigned short wnew = 0;
          
          while ( size-- > 0 )
            {
              put_unsigned_word( dest, wnew = get_unsigned_word( src ) + wnew );
              src += sizeof( wnew );
              dest += sizeof( wnew );
            }
        }
       else
        {
          signed short wnew = 0;
          
          while ( size-- > 0 )
            {
              put_signed_word( dest, wnew = get_signed_word( src ) + wnew );
              src += sizeof( wnew );
              dest += sizeof( wnew );
            }
        }
    }
   else
    {
      if ( type & GUS_WAVE_UNSIGNED )	/* unsigned */
        {
          unsigned char wnew = 0;
          
          while ( size-- > 0 )
            {
              put_unsigned_byte( dest, wnew = get_unsigned_byte( src ) + wnew );
              src += sizeof( wnew );
              dest += sizeof( wnew );
            }
        }
       else
        {
          signed char wnew = 0;

          while ( size-- > 0 )
            {
              put_signed_byte( dest, wnew = get_signed_byte( src ) + wnew );
              src += sizeof( wnew );
              dest += sizeof( wnew );
            }
        }
    }
}

void gus_convert_8bit_to_16bit( unsigned short *dest, unsigned char *src, size_t size )
{
  src += size - 1;
  dest += size - 1;
  while ( size-- > 0 )
    *(dest--) = *(src--);
}
