/*
 *  Copyright (c) 1994/95 by Jaroslav Kysela (Perex soft)
 *  Some I/O routines for GF1 and CS4231 chips
 */

#include "gus_dev.h"

void gus_delay( void )
{
  short i;
  
  for ( i = 0; i < 6; i++ )
    {
      MB();
      INB( GUSP( DRAM ) );
    }
}

void gus_poke( unsigned int addr, unsigned char data )
{
  OUTB( 0x43, GUSP( GF1REGSEL ) ); MB();
  OUTW( (unsigned short)(addr & 0xffff), GUSP( GF1DATALOW ) ); MB();
  OUTB( 0x44, GUSP( GF1REGSEL ) ); MB();
  OUTB( (unsigned char)( (addr >> 16) & 0xff ), GUSP( GF1DATAHIGH ) ); MB();
  OUTB( data, GUSP( DRAM ) );
}

unsigned char gus_peek( unsigned int addr )
{
  OUTB( 0x43, GUSP( GF1REGSEL ) ); MB();
  OUTW( (unsigned short)(addr & 0xffff), GUSP( GF1DATALOW ) ); MB();
  OUTB( 0x44, GUSP( GF1REGSEL ) ); MB();
  OUTB( (unsigned char)( (addr >> 16) & 0xff ), GUSP( GF1DATAHIGH ) ); MB();
  return INB( GUSP( DRAM ) );
}

void gus_write_addr( unsigned char reg, unsigned int addr, short w_16bit )
{
  unsigned int hold_addr;

  if ( w_16bit )
    {
      hold_addr = addr;
      addr >>= 1;
      addr &= 0x1ffff;
      addr |= hold_addr & 0xc0000;	/* copy bank bits */
    }
  gus_write16( reg, (unsigned short)( addr >> 7 ) );
  gus_write16( reg + 1, (unsigned short)( addr << 9 ) );
}

unsigned int gus_read_addr( unsigned char reg, short w_16bit )
{
  unsigned int res;
  unsigned int hold_addr;
  
  res = ( (unsigned int)gus_read16( reg ) << 7 ) & 0xfff80;
  res |= ( (unsigned int)gus_read16( reg + 1 ) >> 9 ) & 0x0007f;
  if ( w_16bit )
    {
      hold_addr = res;
      res &= 0x1ffff;
      res <<= 1;
      res |= hold_addr & 0xc0000;	/* copy bank bits */
    }
  return res;
}

void codec_outm( unsigned char reg, unsigned char mask, unsigned char value )
{
  unsigned char tmp;

  OUTB( reg, CODECP( REGSEL ) ); MB();
  tmp = ( INB( CODECP( REG ) ) & mask ) | value;
  OUTB( reg, CODECP( REGSEL ) );
  OUTB( tmp, CODECP( REG ) ); MB();
}

#if 0

void codec_debug()
{
  short i;

  PRINTK( "CODEC REGS (0-15):\n" );
  for ( i = 0; i < 16; i++ )
    printk( "0x%02x    ", codec_in( i ) );
  PRINTK( "\n" );
  PRINTK( "CODEC REGS (16-32):\n" );
  for ( i = 16; i < 32; i++ )
    printk( "0x%02x    ", codec_in( i ) );
  PRINTK( "\n" );
}

#endif
