unit Page3_1;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGDsgFrm, StdCtrls, PGSubCls, ExtCtrls, Menus, Buttons;

type
  TFormPage3_1 = class(TForm)
    CaptionBar: TPGCaptionBar;
    PGCaptionBarGlyph1: TPGCaptionBarGlyph;
    Panel1: TPanel;
    CaptionBarButton: TPGCaptionBarButton;
    GlyphLayoutMenu: TPopupMenu;
    CaptionBarToggleButton: TPGCaptionBarGlyph;
    Layout: TMenuItem;
    Align1: TMenuItem;
    AlignLeft1: TMenuItem;
    AlignRight1: TMenuItem;
    GlyphOnLeft2: TMenuItem;
    GlyphOnRight2: TMenuItem;
    GlyphOnTop2: TMenuItem;
    GlyphOnBottom2: TMenuItem;
    Panel5: TPanel;
    Button1: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label1: TLabel;
    procedure GlyphOnLeft2Click(Sender: TObject);
    procedure GlyphOnRight2Click(Sender: TObject);
    procedure GlyphOnTop2Click(Sender: TObject);
    procedure GlyphOnBottom2Click(Sender: TObject);
    procedure CaptionBarToggleButtonClick(Sender: TObject);
    procedure AlignLeft1Click(Sender: TObject);
    procedure AlignRight1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  public
    procedure UncheckGlyphLayouts;
  end;

var
  FormPage3_1: TFormPage3_1;

implementation

uses Main;

{$R *.DFM}


procedure TFormPage3_1.UncheckGlyphLayouts;
begin
  GlyphOnLeft2.Checked := false;
  GlyphOnRight2.Checked := false;
  GlyphOnTop2.Checked := false;
  GlyphOnBottom2.Checked := false;
end;

procedure TFormPage3_1.GlyphOnLeft2Click(Sender: TObject);
begin
  UncheckGlyphLayouts;
  GlyphOnLeft2.Checked := true;
  CaptionBarButton.Layout := blGlyphLeft;
end;

procedure TFormPage3_1.GlyphOnRight2Click(Sender: TObject);
begin
  UncheckGlyphLayouts;
  GlyphOnRight2.Checked := true;
  CaptionBarButton.Layout := blGlyphRight;
end;

procedure TFormPage3_1.GlyphOnTop2Click(Sender: TObject);
begin
  UncheckGlyphLayouts;
  GlyphOnTop2.Checked := true;
  CaptionBarButton.Layout := blGlyphTop;
end;

procedure TFormPage3_1.GlyphOnBottom2Click(Sender: TObject);
begin
  UncheckGlyphLayouts;
  GlyphOnBottom2.Checked := true;
  CaptionBarButton.Layout := blGlyphBottom;
end;

procedure TFormPage3_1.CaptionBarToggleButtonClick(Sender: TObject);
begin
  if CaptionBarToggleButton.Down then
    MainForm.ShowMsg('The button is Down.')
  else
    MainForm.ShowMsg('The button is Up.');
end;

procedure TFormPage3_1.AlignLeft1Click(Sender: TObject);
begin
  AlignLeft1.Checked := true;
  AlignRight1.Checked := false;
  CaptionBarButton.Align := taLeftJustify;
end;

procedure TFormPage3_1.AlignRight1Click(Sender: TObject);
begin
  AlignLeft1.Checked := false;
  AlignRight1.Checked := true;
  CaptionBarButton.Align := taRightJustify;
end;

procedure TFormPage3_1.Button1Click(Sender: TObject);
begin
  Close;
end;

end.
