@REM
@REM UNINSTAL.BAT  --  Print-Format Uninstallation
@REM
@ECHO 
@ECHO Print-Format Uninstallation
@ECHO 
@ECHO Searches for the following files and prompts for deletition:
@ECHO 
@ECHO   - *.PRT and *.PRB in the directory, %TEMP% or %TMP% are pointing to
@ECHO 
@ECHO   - PF*.BAT and PF*.PIF in the directory \BAT or \BATCH
@ECHO 
@ECHO   - PF*.PIF in the directory \WIN or \WINDOWS
@ECHO 
@ECHO   - *.* in \PF (deletition without prompting)
@ECHO 
@ECHO Press [Return] to continue, Ctrl+C to abort
@PAUSE > NUL:
@ECHO 
@ECHO Assumes, that - you installed Print-Format in the directory \PF
@ECHO                 of your current drive
@ECHO 
@ECHO               - %TEMP% or %TMP% are set and the Print-Format output 
@ECHO                 files *.PRT and *.PRB, that reside there, are no more used
@ECHO 
@ECHO               - your Print-Format batch files reside in the directory
@ECHO                 \BAT or \BATCH of your current drive
@ECHO 
@ECHO               - your Print-Format PIF files reside in the directory
@ECHO                 \WIN or \WINDOWS of your current drive
@ECHO 
@ECHO Press [Return] to continue, Ctrl+C to abort
@PAUSE > NUL:
@ECHO 
@REM
@IF @%TEMP% == @ GOTO TMP
@IF NOT EXIST %TEMP%\*.PRT GOTO NO_TEMP_PRT
@ECHO 
@ECHO PFU010: Deleting all files *.PRT in directory %TEMP%
@DEL %TEMP%\*.PRT /P
@REM
:NO_TEMP_PRT
@IF NOT EXIST %TEMP%\*.PRB GOTO TMP
@ECHO 
@ECHO PFU011: Deleting all files *.PRB in directory %TEMP%
@DEL %TEMP%\*.PRB /P
@REM
:TMP
@IF @%TMP% == @ GOTO BAT
@IF NOT EXIST %TMP%\*.PRT GOTO NO_TMP_PRT
@ECHO 
@ECHO PFU020: Deleting all files *.PRT in directory %TMP%
@DEL %TMP%\*.PRT /P
@REM
:NO_TMP_PRT
@IF NOT EXIST %TMP%\*.PRB GOTO BAT
@ECHO 
@ECHO PFU021: Deleting all files *.PRB in directory %TMP%
@DEL %TMP%\*.PRB /P
@REM
:BAT
@IF NOT EXIST \BAT\PF*.BAT GOTO BAT2
@ECHO 
@ECHO PFU030: Deleting all files PF*.BAT in directory \BAT
@DEL \BAT\PF*.BAT /P
@REM
:BAT2
@IF NOT EXIST \BAT\PF*.PIF GOTO BAT3
@ECHO 
@ECHO PFU031: Deleting all files PF*.PIF in directory \BAT
@DEL \BAT\PF*.PIF /P
@REM
:BAT3
@IF NOT EXIST \BATCH\PF*.BAT GOTO BAT4
@ECHO 
@ECHO PFU032: Deleting all files PF*.BAT in directory \BATCH
@DEL \BATCH\PF*.BAT /P
@REM
:BAT4
@IF NOT EXIST \BATCH\PF*.PIF GOTO WIN
@ECHO 
@ECHO PFU033: Deleting all files PF*.PIF in directory \BATCH
@DEL \BATCH\PF*.PIF /P
@REM
:WIN
@IF NOT EXIST \WIN\PF*.PIF GOTO WIN2
@ECHO 
@ECHO PFU040: Deleting all files PF*.PIF in directory \WIN
@DEL \WIN\PF*.PIF /P
@REM
:WIN2
@IF NOT EXIST \WINDOWS\PF*.PIF GOTO PF
@ECHO 
@ECHO PFU041: Deleting all files PF*.PIF in directory \WINDOWS
@DEL \WINDOWS\PF*.PIF /P
@REM
:PF
@IF NOT EXIST \PF\*.* GOTO PF_DIR
@ECHO 
@ECHO PFU050: Deleting all files *.* in directory \PF
@ECHO 
@ECHO Press [Return] to continue, Ctrl+C to abort
@PAUSE > NUL:
@DEL \PF\*.*
@REM
:PF_DIR
@ECHO 
@ECHO PFU051: Deleting directory \PF
@RMDIR \PF
@ECHO 
@ECHO Print-Format Uninstallation done  --  Goodbye!
@ECHO 