/*REXX*/
main:
parse arg lbegbal lrate lfactor lnumpay

  if lbegbal <> '' & TRANSLATE(lbegbal) <> '/DEBUG' then
   do
    if lnumpay = '' then lnumpay = 360
    if lfactor = '' then lfactor = 12
    if lrate   = '' then lrate   = 8.75
    call rDoLoanCalc lbegbal, lrate, lfactor, lnumpay, 'N'
    do i = 1 to d.0
     say d.i
    end
   end
  else
   do
    if TRANSLATE(lbegbal) = '/DEBUG' then
     Call Trace ?r
    NUMERIC DIGITS 6
    irc = 0
    rc   = rLoadFuncs('rxPDLoadFuncs', 'HSSPD')
    if rc <> 0 then
     do
      Call BEEP 524, 250
      Call BEEP 262, 250
      say 'LOAN - Unable to initialize the "RXPD" subsystem'
      exit 8
     end
    NUMERIC DIGITS 33
    bid  = rxPDInit('LOAN','YELLOWHI', 'REDHI', 'WHITE')
    rc   = rxPDZVarDefine()
/*  svid = rxPDSaveScreen(bid)*/
    /* Now we init the panel variables */
    lbegbal   = '0.00'
    lrate     = '0.00'
    lfactor   = '0'
    lnumpay   = '0'
    fDlbegbal = ''
    fDlrate   = ''
    fDlfactor = ''
    fDlnumpay = ''
    fDwpa  = ''
    fDwip  = ''
    fDwfp  = ''
    fDwnop = ''
    fDwpp  = ''
    fDwdpb = ''
    fDwpia = ''
    fDwaib = ''
    /* And define them so that we get proper care and feeding */
    rc = rxPDVarDefine(bid, 'fDlbegbal', ZVTYPE_DOUBLE, 2)
    rc = rxPDVarDefine(bid, 'fDlrate'  , ZVTYPE_DOUBLE, 3)
    rc = rxPDVarDefine(bid, 'fDlfactor', ZVTYPE_LONG, 3)
    rc = rxPDVarDefine(bid, 'fDlnumpay', ZVTYPE_LONG, 3)
    rc = rxPDVarDefine(bid, 'fDwpa', ZVTYPE_DOUBLE+ZVTYPE_RIGHTADJUST, 2)
    rc = rxPDVarDefine(bid, 'fDwip', ZVTYPE_DOUBLE+ZVTYPE_RIGHTADJUST, 3)
    rc = rxPDVarDefine(bid, 'fDwpp', ZVTYPE_DOUBLE+ZVTYPE_RIGHTADJUST, 2)
    rc = rxPDVarDefine(bid, 'fDwdpb', ZVTYPE_DOUBLE+ZVTYPE_RIGHTADJUST, 2)
    rc = rxPDVarDefine(bid, 'fDwpia', ZVTYPE_DOUBLE+ZVTYPE_RIGHTADJUST, 2)
    rc = rxPDVarDefine(bid, 'fDwaib', ZVTYPE_DOUBLE+ZVTYPE_RIGHTADJUST, 2)
    rc = rxPDVarDefine(bid, 'fDwfp', ZVTYPE_LONG+ZVTYPE_RIGHTADJUST, 3)
    rc = rxPDVarDefine(bid, 'fDwnop', ZVTYPE_LONG+ZVTYPE_RIGHTADJUST, 3)
/***
***/
    sKey = rxPDDisplay(bid,'PANEL000')
    do while 0 = rDoLoan(bid)
    end /*do while 0 = rDoLoan(bid)*/
/*  rc = rxPDRestoreScreen(bid, svid)*/
    rc = rxPDTerm(bid)
   end

  exit 0

/**********************************************************************\
 rDoLoan:
  This routine displays a dialog panel for the required LOAN data.
  It then calls the lon calculation routine followed by the loan
  display routine.
\**********************************************************************/
rDoLoan:
parse arg bid

  fDlbegbal = lbegbal
  fDlrate   = lrate
  fDlfactor = lfactor
  fDlnumpay = lnumpay

  skey = ZESC
  do while sKey = ZESC
   sKey = rxPDDisplay(bid,'PANEL001')
  end /*do while sKey = ZESC*/

  if sKey = ZF3 then
   do
    return 8
   end

  lbegBal = fDlbegbal
  lrate   = fDlrate
  lfactor = fDlfactor
  lnumpay = fDlnumpay

  call rDoLoanCalc lbegbal, lrate, lfactor, lnumpay, 'Y'

  Call rDoLoanDisplay bid

  return 0;

/**********************************************************************\
 rDoLoanDisplay:
  This routine displays a dialog panel containing the results of the
  loan calculation routine.
\**********************************************************************/
rDoLoanDisplay:
parse arg bid
  sKey = rxPDDisplay(bid,'PANEL002')
  return 0;

/**********************************************************************\
 rDoLoanCalc:
  This routine performes the calculation of the desired loan.
  This routine is independent of the mode of end user interface by
  building a stem variable that will be used by either the command
  line interface or the dialog interface.

  Calculations are done using the following formula:

            --                                          --
            |                                            |
            |                    I                       |
            |                                            |
  PMT = B * |  ________________________________________  |
            | --                                      -- |
            | |    --                              --  | |
            | |    |                                |  | |
            | |    |               1                |  | |
            | |1 - |  ___________________________   |  | |
            | |    | --                         --  |  | |
            | |    | |  --             -- N      |  |  | |
            | |    | |  |     1 + I     |        |  |  | |
            | |    | |  --             --        |  |  | |
            | |    | --                         --  |  | |
            | |    --                              --  | |
            | --                                      __ |
            --                                          --

  PMT = B * ( I / ( 1 - ( 1 / ( ( 1 + I ) ** N ) ) ) )
\**********************************************************************/
rDoLoanCalc:
/*Call Trace ?r*/
parse arg lbegbal, lrate, lfactor, lnumpay, fPD
  /*lnumpay = lnumpay * lfactor;*/
  b = lbegbal;
  i = FORMAT(lrate / 100,9,6);
  i = FORMAT(i / lfactor,9,6);
  n = lnumpay;
  ir = i + 1;
  ir = FORMAT(ir ** n,9,6);
  ir = FORMAT(1 / ir,9,6);
  ir = FORMAT(1 - ir,9,6);
  ir = FORMAT(i / ir,9,6);
  p = FORMAT(b * ir,9,6);
  wpia = b;
  wpa = b;
  tb = FORMAT(p * n,9,6);
  wdpb = tb;
  waib = FORMAT(tb - b,9,6);
  wip = lrate;
  wfp = lfactor;
  wnop = n;
  wpp = p;

  /* Build Display Stem */
  if fPD = 'N' then
   do
    d.1 =' '
    d.2 ='                                         <***********************************>'
    d.3 ='                                         <Principle            :    'FORMAT(wpa,6,2)'>'
    d.4 ='                                         <Interest & Periods   : 'FORMAT(wip,2,2)'% &  'FORMAT(wfp,2,0)'>'
    d.5 ='                                         <Number of Payments   :          'FORMAT(wnop,3,0)'>'
    d.6 ='                                         <***********************************>'
    d.7 =' '
    d.8 =' Period Payment = 'FORMAT(wpp,4,2)
    d.9 =' '
    d.10=' Total Amount of Payments = ' FORMAT(wdpb,6,2)
    d.11=' - Amount of Loan         = ' FORMAT(wpia,6,2)
    d.12='                            ---------'
    d.13=' Total Interest Payed     = ' FORMAT(waib,6,2)
    d.0 = 13;
   end

  /* Build Display Variables */
  if fPD = 'Y' then
   do
    fDwpa  = FORMAT(wpa,6,2)
    fDwip  = FORMAT(wip,2,2)
    fDwfp  = FORMAT(wfp,2,0)
    fDwnop = FORMAT(wnop,3,0)
    fDwpp  = FORMAT(wpp,4,2)
    fDwdpb = FORMAT(wdpb,6,2)
    fDwpia = FORMAT(wpia,6,2)
    fDwaib = FORMAT(waib,6,2)
    /****
    fDwpa  = RIGHT(FORMAT(wpa,6,2),11,' ')
    fDwip  = FORMAT(wip,2,2)||'%'
    fDwfp  = FORMAT(wfp,2,0)
    fDwnop = RIGHT(FORMAT(wnop,3,0),11,' ')
    fDwpp  = RIGHT(FORMAT(wpp,4,2),10,' ')
    fDwdpb = RIGHT(FORMAT(wdpb,6,2),10,' ')
    fDwpia = RIGHT(FORMAT(wpia,6,2),10,' ')
    fDwaib = RIGHT(FORMAT(waib,6,2),10,' ')
    ***/
   end

  return

rLoadFuncs:
parse arg sRtn, sDll
  rxrc = RxFuncAdd(sRtn, sDll, sRtn)
  signal on syntax name xLoadFuncs
  interpret 'Call 'sRtn
  return 0

xLoadFuncs:
  return 127
