;ͻ
; Script: timesub.sc      Creation Date: 11/21/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Subtracts the time in variable time2.a from the time in        
; variable time1.a. Times must be in the HH:MM:SS format. If the answer is    
; negative, a dash (-) is placed before the result.                           
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC timesub.a(time1.a, time2.a)
  PRIVATE time1hr.n, time1min.n, time1sec.n, time2hr.n, time2min.n, time2sec.n,
  newsec.n, newmin.n, newhr.n, newsec.a, newmin.a, newhr.a, flag.l

  time1hr.n = NUMVAL(SUBSTR(time1.a, 1, 2))      ; turn strings into numbers
  time1min.n = NUMVAL(SUBSTR(time1.a, 4, 2))
  time1sec.n = NUMVAL(SUBSTR(time1.a, 7, 2))

  time2hr.n = NUMVAL(SUBSTR(time2.a, 1, 2))
  time2min.n = NUMVAL(SUBSTR(time2.a, 4, 2))
  time2sec.n = NUMVAL(SUBSTR(time2.a, 7, 2))

  IF time2sec.n > time1sec.n THEN                ; make sure we can do subtraction
    time1sec.n = time1sec.n + 60
    time1min.n = time1min.n - 1
  ENDIF

  IF time2min.n > time1min.n THEN
    time1min.n = time1min.n + 60
    time1hr.n = time1hr.n - 1
  ENDIF

  newsec.n = time1sec.n - time2sec.n             ; doing the math
  newmin.n = time1min.n - time2min.n
  newhr.n = time1hr.n - time2hr.n

  IF newsec.n < 10 THEN                          ; formatting string with leading
    newsec.a = "0" + STRVAL(newsec.n)            ; zero if necessary
    IF SUBSTR(newsec.a, 2, 1) = " " THEN
      newsec.a = SUBSTR(newsec.a, 1, 1) + SUBSTR(newsec.a, 3, 1)
    ENDIF
  ELSE
    newsec.a = STRVAL(newsec.n)
  ENDIF

  IF newmin.n < 10 THEN
    newmin.a = "0" + STRVAL(newmin.n)
    IF SUBSTR(newmin.n, 2, 1) = " " THEN
      newmin.n = SUBSTR(newmin.n, 1, 1) + SUBSTR(newmin.a, 3, 1)
    ENDIF
  ELSE
    newmin.a = STRVAL(newmin.n)
  ENDIF

  IF newhr.n < 0 THEN                            ; check for negative number
    flag.l = TRUE
    newhr.n = newhr.n * -1                       ; if so make positive
  ENDIF

  IF newhr.n < 10 THEN
    newhr.a = "0" + STRVAL(newhr.n)
    IF SUBSTR(newhr.a, 2, 1) = " " THEN
      newhr.a = SUBSTR(newhr.a, 1, 1) + SUBSTR(newhr.a, 3, 1)
    ENDIF
  ELSE
    newhr.a = STRVAL(newhr.n)
  ENDIF

  IF flag.l THEN                                 ; add the dash if it was negative
    newhr.a = "-" + newhr.a
  ENDIF

  RETURN newhr.a + ":" + newmin.a + ":" + newsec.a

ENDPROC
WRITELIB libname timesub.a
RELEASE PROCS timesub.a
