;ͻ
; Script: timeadd.sc      Creation Date: 11/21/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Adds two times together to get the new time. The values must   
; be in the HH:MM:SS format. If the total hours exceed 24, only the total will
; be returned. Use the hrs2days.a routine to determine the number of days,    
; if desired.                                                                 
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ


PROC timeadd.a(time1.a, time2.a)
  PRIVATE time1hr.n, time1min.n, time1sec.n, time2hr.n, time2min.n, time2sec.n,
  newsec.n, newmin.n, newhr.n, newsec.a, newmin.a, newhr.a

  time1hr.n = NUMVAL(SUBSTR(time1.a, 1, 2))      ; turning strings into numbers
  time1min.n = NUMVAL(SUBSTR(time1.a, 4, 2))
  time1sec.n = NUMVAL(SUBSTR(time1.a, 7, 2))

  time2hr.n = NUMVAL(SUBSTR(time2.a, 1, 2))
  time2min.n = NUMVAL(SUBSTR(time2.a, 4, 2))
  time2sec.n = NUMVAL(SUBSTR(time2.a, 7, 2))

  newsec.n = time1sec.n + time2sec.n             ; doing the math and adjusting
  IF newsec.n >= 60 THEN                         ; minutes and hours as necessary
    time1min.n = time1min.n + 1
    newsec.n = newsec.n - 60
  ENDIF

  newmin.n = time1min.n + time2min.n
  IF newmin.n >= 60 THEN
    time1hr.n = time1hr.n + 1
    newmin.n = newmin.n - 60
  ENDIF

  newhr.n = time1hr.n + time2hr.n

  IF newsec.n < 10 THEN
    newsec.a = "0" + SUBSTR(STRVAL(newsec.n), 1, 2)    ; formatting the string, if necessary
    IF SUBSTR(newsec.a, 2, 1) = " " THEN
      newsec.a = SUBSTR(newsec.a, 1, 1) + SUBSTR(newsec.a, 3, 1)
    ENDIF
  ELSE
    newsec.a = STRVAL(newsec.n)
  ENDIF

  IF newmin.n < 10 THEN
    newmin.a = "0" + SUBSTR(STRVAL(newmin.n), 1, 2)
    IF SUBSTR(newmin.a, 2, 1) = " " THEN
      newmin.a = SUBSTR(newmin.a, 1, 1) + SUBSTR(newmin.a, 3, 1)
    ENDIF
  ELSE
    newmin.a = STRVAL(newmin.n)
  ENDIF

  IF newhr.n < 10 THEN
    newhr.a = "0" + SUBSTR(STRVAL(newhr.n), 1, 2)
    IF SUBSTR(newhr.a, 2, 1) = " " THEN
      newhr.a = SUBSTR(newhr.a, 1, 1) + SUBSTR(newhr.a, 3, 1)
    ENDIF
  ELSE
    newhr.a = STRVAL(newhr.n)
  ENDIF

  RETURN newhr.a + ":" + newmin.a + ":" + newsec.a

ENDPROC
WRITELIB libname timeadd.a
RELEASE PROCS timeadd.a
