;ͻ
; Script: time2num.sc     Creation Date:01/08/93  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Converts time in HH:MM:SS format to the number of milliseconds 
; since midnight. This can then be stored in a two-byte numeric field rather  
; than using an 8-byte string field. The NUM2TIME function returns the number 
; to its original format.                                                     
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC time2num.n(time.a)
  PRIVATE time.a, tickspermin.n, timenum.n

  tickspermin.n = 1000 * 60

  timenum.n = (NUMVAL(SUBSTR(time.a, 1, 2)) * 60) * tickspermin.n ; calc hours

  timenum.n = timenum.n + NUMVAL(SUBSTR(time.a, 4, 2)) * tickspermin.n   ; calc minutes

  timenum.n = timenum.n + (NUMVAL(SUBSTR(time.a, 7, 2)) * 1000)   ; calc seconds

  RETURN timenum.n

ENDPROC
WRITELIB libname time2num.n
RELEASE PROCS time2num.n
