;ͻ
; Script: textbox.sc      Creation Date: 11/23/91 Author:J. Grinstead       
;                         Last Revision: 09/22/92 Revised By: J. Grinstead  
;Ķ
; Description: Gets a line of text via a dialog box. Can then format text     
; to either all caps, all lower case to with each word capitalized.           
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                       lrtrim.a ()                      
;                                       evenodd.a ()                     
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC textbox.a (hed.a, chars.n, styl.n)
  PRIVATE choice.a, styl.n, chars.n, hed.a, width.n, center.n, result.a

  width.n = LEN(hed.a)
  width.n = max(width.n, chars.n) + 10      ; find width of longer element
                                            ; and make room for dialog features

  IF evenodd.a(width.n) = "O" THEN          ; make even, so divisible by two
    width.n = width.n + 1                   ; for center
  ENDIF

  IF width.n < 32 THEN                      ; box must be at least 32 to display
    width.n = 32
  ENDIF

  center.n = width.n / 2                    ; find center

  okbutton.n = ROUND((center.n / 2) - 6,0)  ; create locations for buttons
  cancelbutton.n = ROUND(center.n + (center.n / 2) - 6,0)

  choice.a = ""
  SHOWDIALOG hed.a
    @ 8, 40 - center.n
    HEIGHT 7 WIDTH width.n

    ACCEPT @ 1, center.n - (round((chars.n / 2), 0) + 3)   ; getting text
      WIDTH chars.n + 3
      "A" + STRVAL(chars.n)
      TAG "Text"
    TO choice.a

    PUSHBUTTON                              ; OK button
      @ 3, okbutton.n
      WIDTH 10
      "~O~K"
      OK
      VALUE "OK"
      TAG "OK"
    TO result.a

    PUSHBUTTON                              ; cancel button
      @ 3, cancelbutton.n
      WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "Cancel"
      TAG "Cancel"
    TO result.a
ENDDIALOG

IF IsBlank(choice.a) THEN                   ; user bailed out
  RETURN "ESC"
ENDIF


SWITCH                                      ; format data if necessary
  CASE styl.n = 1:
    choice.a = UPPER(choice.a)
  CASE styl.n = 2:
    choice.a = LOWER(choice.a)
  CASE styl.n = 3:
    choice.a = FORMAT("w"+STRVAL(length.n) + ", CC", choice.a)
ENDSWITCH

choice.a = lrtrim.a(choice.a)               ; get rid of extra spaces

RETURN choice.a

ENDPROC
WRITELIB libname textbox.a
RELEASE PROCS textbox.a
