;ͻ
; Script: sortarya.sc     Creation Date: 11/07/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Sorts an array (not a dynarray) into an ascending order.       
;                                                                             
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC sortarraya.v(work.r)
  PRIVATE work.r, swapvar.v, change.l

  size.n = ARRAYSIZE (work.r)               ; find out array size

  WHILE TRUE
    change.l = FALSE                        ; initialize change flag
    FOR x FROM 1 TO size.n - 1              ; avoid running past declared size
      IF IsAssigned(work.r[x + 1]) THEN     ; make sure we don't compare with blank
        IF work.r[x] > work.r[x + 1] THEN
          swapvar.v = work.r[x]
          work.r[x] = work.r[x + 1]
          work.r[x + 1] = swapvar.v
          change.l = TRUE                   ; note a change was made
        ENDIF
      ELSE
        QUITLOOP
      ENDIF
    ENDFOR
    IF NOT change.l THEN                    ; no changes, so quit loop
      QUITLOOP
    ENDIF
  ENDWHILE

ENDPROC
WRITELIB libname sortarraya.v
RELEASE PROCS sortarraya.v
