;ͻ
; Script: searchrp.sc     Creation Date:03/29/92  Author: J. Grinstead      
;                         Last Revision:10/04/92  Revised By: J. Grinstead  
;Ķ
; Description: A routine to search and replace characters in a string field.  
;                                                                             
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC replace.u ()
  PRIVATE fieldtype.a, length.n, confirm.n, x, contents.a, contents.v, test.n,
  test.l, left.a, right.n, position.n, counter.n, replace.v, fulltype.a, find.v


  IF NImages () < 1 THEN; must be images on the workspace
    MESSAGE " No table to search "
    BEEP BEEP BEEP BEEP
    SLEEP 2500
    RETURN
  ENDIF

  mode.a = SYSMODE ()                       ; must also be in edit or coedit mode
  SWITCH
    CASE mode.a = "Edit":
    CASE mode.a = "CoEdit":
    OTHERWISE:
      MESSAGE " Must be in EDIT or COEDIT mode to replace. Current mode is " + mode.a
      BEEP BEEP BEEP BEEP
      SLEEP 2500
      RETURN
  ENDSWITCH

  fieldtype.a = FieldType()                 ; ensures only a string field is used
  IF SUBSTR(fieldtype.a, 1, 1) = "A" THEN
    fulltype.a = fieldtype.a
    exact.n = 1
    length.n = NUMVAL(SUBSTR(fieldtype.a, 2, 255))  ; can search only 13 chars
    fieldtype.a = "A"
    IF length.n > 13 THEN
      length.n = 13
    ENDIF
  ELSE
    MESSAGE " Search only possible on string fields. This is a " + fieldtype.a + " field "
    BEEP BEEP BEEP BEEP
    SLEEP 2500
    RETURN
  ENDIF

  find.v = ""
  replace.v = ""
  confirm.n = 1
  SHOWDIALOG "Search and Replace"           ; set up dialog box
    @ 6, 21
    HEIGHT 10
    WIDTH 33

    @ 1, 1 ?? "Search for  :"
    @ 2, 1 ?? "Replace with:"
    @ 4, 2 ?? "Confirm?"


    ACCEPT @ 1, 15                        ; get string to search for
      WIDTH length.n + 2
      fulltype.a REQUIRED
      TAG "acceptbox"
    TO find.v

    ACCEPT @ 2, 15                       ; get replacement string
      WIDTH length.n + 2
      fulltype.a
      TAG "replacebox"
    TO replace.v

    RADIOBUTTONS
      @ 4, 11                 ; determines if confirm or not
      HEIGHT 1
      WIDTH 16
      "Yes", "No"
      TAG "YesNo"
    TO confirm.n


    PUSHBUTTON
      @ 6, 2                   ;OK and cancel buttons
      WIDTH 10
      "~O~K"
      OK
      VALUE "OK"
      TAG "OK"
    TO exitcode.a

    PUSHBUTTON
      @ 6, 18
      WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "Cancel"
      TAG "Cancel"
    TO exitcode.a
ENDDIALOG

IF find.v = "" THEN
  RETURN ""
ENDIF

counter.n = 0
CURSOR OFF
SCAN                                      ; begin search through file
  WHILE TRUE                              ; allows multiple searches per field
    test.l = MATCH([], ".." + find.v + "..", left.v, right.v)
    IF test.l THEN
      counter.n = counter.n + 1
      ECHO NORMAL
      ECHO OFF
      IF confirm.n = 1 THEN; if confirm, then ask user
        MESSAGE " Replace? Y or N "
        SOUND 100 100
        x = UPPER(CHR(GETCHAR ()))
        IF x <> "Y" THEN
          LOOP
        ENDIF
      ENDIF
      [] = left.v + replace.v + right.v
    ELSE
      QUITLOOP
    ENDIF
  ENDWHILE
ENDSCAN
RETURN counter.n                          ; tell user how many were replaced

ENDPROC
WRITELIB libname replace.u
RELEASE PROCS replace.u
