;ͻ
; Script: search.sc       Creation Date:03/29/92  Author: J. Grinstead      
;                         Last Revision:10/04/92  Revised By: J. Grinstead  
;Ķ
; Description: A search routine to find a string of text.                     
;                                                                             
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                       searchproc.u                     
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC search.u ()
  PRIVATE fieldtype.a, length.n, exact.l, x, contents.a, contents.a, test.n,
  keypress.v, currentfield.a

  IF NImages () < 1 THEN
    RETURN
  ENDIF

  currentfield.a = FIELD ()
  fieldtype.a = FieldType()                 ; determine the field type
  testtype.a=SUBSTR(fieldtype.a,1,1)        ; pull off first letter (important if string)

  SWITCH
    CASE testtype.a = "A" :
      length.n = NUMVAL(SUBSTR(fieldtype.a, 2, 255))
      fulltype.a = fieldtype.a
      fieldtype.a = "A"
      contents.a = ""
    CASE testtype.a = "N" OR
      fieldtype.a = "S" OR
      fieldtype.a = "$" :
      length.n = 8
      fulltype.a = fieldtype.a
      contents.a = BLANKNUM ()
    CASE testtype.a = "D":
      length.n = 8
      fulltype.a = fieldtype.a
      contents.a = BLANKDATE ()
    CASE testtype.a = "M":
      length.n = 8
      fulltype.a = fieldtype.a
      contents.a = ""
  ENDSWITCH

  exact.l = "Exact"

  SHOWDIALOG "Search"                       ; set up dialog box
    PROC "searchproc.u" TRIGGER "Accept"
      @ 6, 24
      HEIGHT 9
      WIDTH 28


      ACCEPT @ 1, 8                        ; get string to search for
        WIDTH length.n + 3
        fulltype.a
        TAG "acceptbox"
      TO contents.a

      RADIOBUTTONS
        @ 3, 1                  ; determines if exact or similar match
        HEIGHT 1
        WIDTH 23
        "Exact", "Similar"
        TAG "Exact"
      TO exact.l


      PUSHBUTTON
        @ 5, 1                   ;OK and cancel buttons
        WIDTH 10
        "~O~K"
        OK
        VALUE "OK"
        TAG "OK"
      TO exitcode.a

      PUSHBUTTON
        @ 5,  14
        WIDTH 10
        "~C~ancel"
        CANCEL
        VALUE "Cancel"
        TAG "Cancel"
      TO exitcode.a
  ENDDIALOG

  IF exact.l = 1 THEN; looking for value
    LOCATE contents.a
  ELSE
    LOCATE PATTERN ".." + contents.a + ".." ; look for for similar value
  ENDIF

  IF NOT RETVAL THEN
    MESSAGE " Not found "
    BEEP
    SLEEP 1500
    RETURN
  ENDIF

  IF RECNO() = NRecords(TABLE()) THEN; at bottom of table -- can't find
    RETURN
  ENDIF

  WHILE TRUE                                ; seeing if they want to search again
    STYLE ATTRIBUTE 79
    WAIT RECORD
      PROMPT " Press Alt-N to search again or ESC to end ", ""
    UNTIL "DOS", "DOSBIG", -49, "ESC", "ZOOM", "ZOOMNEXT", -31
      keypress.v = RETVAL

      SWITCH
        CASE keypress.v = -49:                ; locating next exact or similar
          MOVETO FIELD currentfield.a
          Down
          IF exact.l = 1 THEN
            LOCATE NEXT contents.a
          ELSE
            LOCATE NEXT PATTERN ".." + contents.a + ".."
          ENDIF
          IF NOT RETVAL THEN
            Up
            MESSAGE " Not found "
            BEEP
            SLEEP 1500
            RETURN
          ENDIF
          IF RECNO () = NRecords (TABLE ()) THEN
            RETURN
          ENDIF
          LOOP
        CASE keypress.v = "ESC":              ; bail out
          RETURN
        OTHERWISE:
          LOOP
      ENDSWITCH
    ENDWHILE

  ENDPROC
  WRITELIB libname search.u
  RELEASE PROCS search.u


  PROC searchproc.u (trigger.d, tag.d, event.d, element.d)
    PRIVATE trigger.d, tag.d, event.d, element.d

    test.n = 0
    SWITCH
      CASE fieldtype.a = "N"
        OR fieldtype.a = "S"
        OR fieldtype.a = "$":
        IF exact.l = 2 THEN
          test.n = 1
        ENDIF
      CASE fieldtype.a = "D":
        IF exact.l = 2 THEN
          test.n = 1
        ENDIF
    ENDSWITCH

    IF test.n > 0 THEN
      MESSAGE " Similar matches only allowed in alphanumeric fields "
      SOUND 150 500
      SLEEP 1500
      MESSAGE ""
      SELECTCONTROL "Exact"
      RETURN FALSE
    ENDIF

  ENDPROC
  WRITELIB libname searchproc.u
  RELEASE PROCS searchproc.u
