;ͻ
; Script:restrec.sc       Creation Date:12/29/91  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Restores last deletion made with companion delrec.u ()         
; routine. Routine will restore more current deletion even if edit session has
; ended and table has been removed from workspace. However table must be on   
; workspace for record to be restored. Record is lost when exiting Paradox.   
; Only the most recent deletion can be restored -- others are lost.           
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1992 Jim Grinstead                                          
;                                                                             
;ͼ

PROC restorerec.u ()
  PRIVATE choice.a, test.a

  @10,0                                 ; display inquiry box
  STYLE ATTRIBUTE 47
  SetMargin 20
  TEXT
ͻ
 Restore most current deletion? Y/N   
ͼ
  ENDTEXT
  SetMargin OFF
  STYLE

  WHILE true                            ; confirm restore with user
    @ 11, 57
    ACCEPT "A1" PICTURE "Y,N" TO choice.a

    IF RETVAL = false THEN; see if user pressed ESC
      RETURN false                      ; return a false value if needed
    ENDIF

    SWITCH
      CASE choice.a = "Y":              ; inform user
        MESSAGE " Restoring record . . . "
        QUITLOOP
      CASE choice.a = "N":              ; return false if needed
        RETURN false
      OTHERWISE:                        ; covering other bases
        LOOP
    ENDSWITCH
  ENDWHILE

  test.a = UPPER(SYSMODE())             ; determine mode

  SWITCH
    CASE test.a = "MAIN":               ; if main, switch into coedit, delete
      CoEdit TABLE ()
      Ins                               ; open a new record
      CopyFromArray a$$!.r              ; restore deletion
      Do_It!; then return to main mode
    OTHERWISE:
      Ins                               ; must be in edit or coedit, so delete
      CopyFromArray a$$!.r              ; open a new record and restore old one
  ENDSWITCH

;----------- NOTE: Above code will not protect user in create, form or other modes
;            it is up to the programmer to prevent this routine from being called
;            unless the user is in either main or coedit mode.

ENDPROC
WRITELIB libname restorerec.u
RELEASE PROCS restorerec.u
