;ͻ
; Script: rangerec        Creation Date: 07/21/92 Author: J. Grinstead      
;                         Last Revision: 01/04/93 Revised By: J. Grinstead  
;Ķ
; Description: The routine allows for the selection of a group of records by  
; record number. For example if you want the records numbered 200 to 500, you 
; would call the routine with those two values in the variables.              
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;  Although the EXECUTE command can use strings as long as 255 characters, the
; use of the APPENDARRAY command belong will be limited more by memory than   
; by the length of the string. The length was set at 150 to limit the number  
; of records, but may have to be varied depending upon the size of the records
; in your table. If you get "LOW MEMORY WARNING" messages, adjust this number 
; downward to provide you more space to work. See below for the number to     
; adjust.                                                                     
;ͼ

PROC recordrange.u(start.n, stop.n)
  PRIVATE start.n, stop.n, newtable.a, x, currenttable.a, arraylist.a,
  newarray.a, newarrayname.a, counter.n

  newtable.a = TABLE ()                     ; capture name of current table
  currenttable.a = newtable.a               ; and prepare for new table name

  IF LEN(newtable.a) > 5 THEN; if name too long, then trip to 6
    newtable.a = SUBSTR(newtable.a, 1, 6)
  ENDIF

  x = 1
  newtable.a = newtable.a + "_1"            ; assign new name
  WHILE TRUE
    IF NOT IsTable(newtable.a) THEN; if exist, then increment until
      QUITLOOP                              ; we have a winner
    ENDIF

    newtable.a = SUBSTR(newtable.a, 1, 6) + "_" + STRVAL(x)

    IF LEN(newtable.a) > 8 THEN; checking to see if we went past 9
      newtable.a = SUBSTR(newtable.a, 1, 5) + "_" + STRVAL(x)
    ENDIF
    x = x + 1
  ENDWHILE

  CREATE newtable.a LIKE currenttable.a     ; creating table for records
  CoEdit newtable.a

  MOVETO currenttable.a                     ; move to proper table and record
  MOVETO RECORD start.n

  arraylist.a = ""
  counter.n = 1
  FOR x FROM start.n TO stop.n
    newarray.a = "T" + STRVAL(counter.n)    ; create a unique array name
    newarrayname.a = newarray.a             ; save for array list

    EXECUTE "CopyToArray " + newarray.a  ; move records to array
    Down

    IF arraylist.a =  "" THEN
      arraylist.a = newarrayname.a
    ELSE
      arraylist.a = arraylist.a + "," + newarrayname.a
      IF LEN(arraylist.a) > 150 THEN; see memory notice above
        MOVETO newtable.a
        EXECUTE "APPENDARRAY " + arraylist.a
        MOVETO currenttable.a
        EXECUTE "RELEASE VARS " + arraylist.a   ; free up precious memory
        arraylist.a = ""
      ENDIF
    ENDIF
    counter.n = counter.n + 1
  ENDFOR

  Do_It!

  MOVETO newtable.a
  IF arraylist.a <> "" THEN; adding files to new database
    EXECUTE "APPENDARRAY " + arraylist.a
    EXECUTE "RELEASE VARS " + arraylist.a  ; clear out memory
  ENDIF
  ClearImage
  MOVETO currenttable.a

ENDPROC
WRITELIB libname recordrange.u
RELEASE PROCS recordrange.u
