;ͻ
; Script: printrpt.sc     Creation Date: 11/21/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Handles the printing of a report to printer, screen or file by 
; giving the user those choices. If the decision is made to go to a file, the 
; program prompts for a name and checks to see if that file exists before     
; printing.                                                                   
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                       checkprinter.l                   
;                                       textbox.a                        
;                                       okbox.u                          
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ


PROC printreport.l(table.a, report.a)
  PRIVATE menuchoice.a, test.l, filename.a

  SHOWPOPUP "Print Report To" CENTERED
    "Printer"  : " Send report to printer"       : "Printer",
    "Screen"   : " Send report to screen"        : "Screen",
    "File"     : " Send report to file"          : "File"
  ENDMENU

  UNTIL "enter"
  TO menuchoice.a
  IF menuchoice.a = "Esc" THEN              ; allow user to bail out
    RETURN FALSE
  ENDIF

  IF menuchoice.a = "Printer" THEN
    test.l = checkprinter.l ()              ; make sure printer is ready
    IF NOT test.l THEN
      RETURN FALSE                          ; user cancelled
    ENDIF
  ENDIF

  WHILE TRUE
    IF menuchoice.a = "File" THEN
      filename.a = textbox.a ("Enter file name", 13, 1)   ; getting file name
      IF UPPER(filename.a) = "ESC" THEN     ; user bailed out
        RETURN FALSE
      ENDIF
      IF IsFile(filename.a) THEN            ; seeing if file exists
        okbox.u("File error", "File already exists")
      ELSE
        QUITLOOP
      ENDIF
    ELSE
      QUITLOOP
    ENDIF
  ENDWHILE

  PROMPT " Press F10 for menu",""           ; preparing screen
  MESSAGE " Preparing report "              ; informing user
  {Report} {Output} SELECT table.a          ; ordering report
  SELECT report.a
  SELECT menuchoice.a                       ; sending to appropriate device
  IF menuchoice.a = "File" THEN
    TYPEIN filename.a                       ; or file
    Enter
  ENDIF

  MESSAGE ""                                ; clear message window
  RETURN TRUE                               ; confirm creation of report

ENDPROC
WRITELIB libname printreport.l
RELEASE PROCS printreport.l
