;ͻ
; Script: popval.sc       Creation Date:12/7/91   Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Offers the user a list of validity checks, then sets those     
; checks for the current field. While the routine checks the mode, it does    
; not check to see if the check is proper for the field. For example, you can 
; set an all caps valcheck for a numeric field. The routine can certainly     
; be called, but is intended to be run from a setkey as a pop-up.             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC popval.a ()
  PRIVATE key.n, row.n, col.n, x, valcheck.a

  IF SYSMODE () <> "Edit" THEN; check to see if in edit mode
    MESSAGE " Must be in EDIT mode to enter ValChecks. You are in " + UPPER(SYSMODE ()) + " mode"
    BEEP BEEP BEEP                            ; if not, message and annoy user
    SLEEP 4000                                ; leave message on the screen
    RETURN                                    ; then exit
  ENDIF

  @ 5, 0                                      ; display valcheck screen
  TEXT
ͻ
                               Validity Checks                                
  
  1. All upper case                    12. Date: MM/DD/YY                    
  2. Letters only, all upper case      13. Date: MM/DD/YY (Year supplied)    
  3. Letters only, capitalize first    14. Date: DD-Mon-YY                   
  4. Letters only, no spaces           15. Social Security number            
  5. Cap first letter of field         16. 5-digit ZIP Code                  
  6. Cap first letter of each word     17. ZIP Code: up to 9 digits          
  7. Numbers only                      18. 2-letter state code in caps       
  8. Time: HH:MM -- optional :SS       19. 3-letter day: Ex. Mon             
  9. Phone number: Ex. 555-5555        20. 3-letter month: Ex. Jan           
 10. Phone number: area code optional  21. 2-digit age                       
 11. Sex: M or F                       22. Mr., Mrs. or Ms.                  
ͼ
  ENDTEXT

  PaintCanvas ATTRIBUTE 79 5, 0, 19, 79       ; paint the screen white on red

  PaintCanvas ATTRIBUTE 116 8, 2, 8, 38       ; paint the first line red on white

  WHILE CHARWAITING ()                        ; clear keyboard buffer
    x = GETCHAR ()
  ENDWHILE

  @ 8, 2                                      ; get cursor in proper position

  WHILE true

    CURSOR OFF

    row.n = ROW ()                            ; set position variables
    col.n = COL ()

    key.n = GETCHAR ()                        ; get keypress from user

    SWITCH; handle key pressed

      CASE key.n = 27:                   ; ESC
        QUITLOOP

      CASE key.n = -80:                  ; down
        PaintCanvas ATTRIBUTE 79 row.n, col.n, row.n, col.n + 36  ; fix current line
        SWITCH
          CASE row.n = 18 AND col.n = 2:  ; if at bottom, move to top of next col
            row.n = 8
            col.n = 41
          CASE row.n = 18 AND col.n = 41: ; if at bottom of second column, move to first
            row.n = 8
            col.n = 2
          OTHERWISE:                      ; move down a line
            row.n = row.n + 1
        ENDSWITCH
        @ row.n, col.n                    ; reposition cursor so variables can be set above
        PaintCanvas ATTRIBUTE 116 row.n, col.n, row.n, col.n + 36 ; show user we've moved
        LOOP                              ; get another keypress

      CASE key.n = -72:                  ; up
        PaintCanvas ATTRIBUTE 79 row.n, col.n, row.n, col.n + 36  ; reset color of current line
        SWITCH
          CASE row.n = 8 AND col.n = 2:  ; if at top, move to bottom of next column
            row.n = 18
            col.n = 41
          CASE row.n = 8 AND col.n = 41: ; if at top of second column, move to bottom of first
            row.n = 18
            col.n = 2
          OTHERWISE:                     ; go up one line
            row.n = row.n - 1
        ENDSWITCH
        @ row.n, col.n                   ; fix cursor at new position
        PaintCanvas ATTRIBUTE 116 row.n, col.n, row.n, col.n + 36  ; show user we've moved
        LOOP

      CASE key.n = -75:                  ; left
        PaintCanvas ATTRIBUTE 79 row.n, col.n, row.n, col.n + 36  ; reset color of current position
        IF col.n = 2 THEN; if in left column, move to right
          col.n = 41
        ELSE
          col.n = 2                      ; must be in right column, so move to left
        ENDIF
        @ row.n, col.n                   ; move cursor
        PaintCanvas ATTRIBUTE 116 row.n, col.n, row.n, col.n + 36  ; show user we've moved
        LOOP

      CASE key.n = -77:                  ; right
        PaintCanvas ATTRIBUTE 79 row.n, col.n, row.n, col.n + 36 ; reset color of current position
        IF col.n = 2 THEN; if in column one, move to column two
          col.n = 41
        ELSE; must be in column two, so move to one
          col.n = 2
        ENDIF
        @ row.n, col.n                   ; move cursor
        PaintCanvas ATTRIBUTE 116 row.n, col.n, row.n, col.n + 36  ; let user know we've moved
        LOOP

      CASE key.n = 13:                   ; enter
        QUITLOOP                         ; leave loop with current positons

      OTHERWISE:                         ; get rid of unwanted keystrokes
        LOOP
    ENDSWITCH

  ENDWHILE

  SWITCH; set value of valcheck.a based on where cursor was in chart
    CASE col.n = 2:                      ; if on left side, fill in following choices
      SWITCH
        CASE row.n = 8:              ; choice 1
          valcheck.a = "*!"
        CASE row.n = 9:              ; choice 2
          valcheck.a = "*&"
        CASE row.n = 10:             ; choice 3
          valcheck.a = "&*?"
        CASE row.n = 11:             ; choice 4
          valcheck.a = "*?"
        CASE row.n = 12:             ; choice 5
          valcheck.a = "!*@"
        CASE row.n = 13:             ; choice 6
          valcheck.a = "*[![*?][* ]]"
        CASE row.n = 14:             ; choice 7
          valcheck.a = "*#"
        CASE row.n = 15:             ; choice 8
          valcheck.a = "{0#,1#,2{0,1,2,3}}:{0,1,2,3,4,5}#[:{0,1,2,3,4,5}#]"
        CASE row.n = 16:             ; choice 9
          valcheck.a = "###-####"
        CASE row.n = 17:             ; choice 10
          valcheck.a = "[(###) ]###-####"
        CASE row.n = 18:             ; choice 11
          valcheck.a = "M,F"
      ENDSWITCH
    CASE col.n = 41:                           ; if on right side, make these choices
      SWITCH
        CASE row.n = 8:              ; choice 12
          valcheck.a = "{##/##/##,#/##/##}"
        CASE row.n = 9:              ; choice 13
          valcheck.a = "{##/##/" + SUBSTR(YEAR(TODAY()),3,2) + ",#/##/"+ SUBSTR(YEAR(TODAY()),3,2) + "}"

        CASE row.n = 10:             ; choice 14
          valcheck.a = "##-{Feb,Sep,Oct,Nov,Dec,J{an,u{n,l}},Ma{r,y},A{pr,ug}}-##"
        CASE row.n = 11:             ; choice 15
          valcheck.a = "###-##-####"
        CASE row.n = 12:             ; choice 16
          valcheck.a = "#####"
        CASE row.n = 13:             ; choice 17
          valcheck.a = "#####[-####]"
        CASE row.n = 14:             ; choice 18
          valcheck.a = "&&"
        CASE row.n = 15:             ; choice 19
          valcheck.a = "{Mon,T{ue,hu},Wed,Fri,S{at,un}}"
        CASE row.n = 16:             ; choice 20
          valcheck.a = "Feb,Sep,Oct,Nov,Dec,J{an,u{n,l}},Ma{r,y},A{pr,ug}"
        CASE row.n = 17:             ; choice 21
          valcheck.a = "#[#]"
        CASE row.n = 18:             ; choice 22
          valcheck.a = "{M{r,rs,s}}."
      ENDSWITCH
  ENDSWITCH

  Menu {ValCheck} {Define} Enter {Picture}
  CtrlBackspace
  TYPEIN valcheck.a
  Enter

ENDPROC
WRITELIB libname popval.a
RELEASE PROCS popval.a
