;ͻ
; Script: popcal.sc       Creation Date:10/24/92  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: A pop-up calendar program. Can easily be invoked by a setkey   
; to allow a calendar window to pop up in the center of the screen. Arrow     
; keys move the calendar forward or backward as needed.                       
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC popcal.u ()
  PRIVATE calwinattrib, calwindow.h, date.d, setdate.d, test.a, row.n, startdate.d, startcol.n,
  month.a, lastday.n, printdate.a, keystroke.n, prepdate.a

  DYNARRAY calwinattrib[]                   ; attribute array for window
  calwinattrib["MAXIMIZED"] = FALSE
  calwinattrib["ECHO"] = TRUE
  calwinattrib["MARGIN"] = "OFF"
  calwinattrib["SCROLLROW"] = 0
  calwinattrib["CANCLOSE"] = TRUE
  calwinattrib["TITLE"] = "Today's Date: " + STRVAL(TODAY ())
  calwinattrib["CANVASWIDTH"] = 36
  calwinattrib["ORIGINROW"] = 2
  calwinattrib["STYLE"] = 31
  calwinattrib["CANRESIZE"] = FALSE
  calwinattrib["CANMAXIMIZE"] = FALSE
  calwinattrib["CANMOVE"] = TRUE
  calwinattrib["HASFRAME"] = FALSE
  calwinattrib["FLOATING"] = TRUE
  calwinattrib["CANVASHEIGHT"] = 20
  calwinattrib["ORIGINCOL"] = 21
  calwinattrib["CANVAS"] = TRUE
  calwinattrib["WIDTH"] = 37
  calwinattrib["HASSHADOW"] = TRUE
  calwinattrib["HEIGHT"] = 20
  calwinattrib["SCROLLCOL"] = 0


  WINDOW CREATE FLOATING @ 2, 21            ; create window for calendar
  HEIGHT 20
  WIDTH 37
  ATTRIBUTES calwinattrib
  TO calwindow.h

  SetMargin 2
  @ 1, 0                                 ; display calendar form
  TEXT
ͻ
                              
Ķ
  S   M   T   W   T   F   S   
Ķ
                              
                              
                              
                              
                              
                              
ͼ

 Use arrow keys to select month

        Press ESC to exit
  ENDTEXT
  SetMargin OFF

  date.d = TODAY ()                         ; get current date
                                            ; then use it to fix the date for the
                                            ; first of the month
                                            ; the program must know on what day
                                            ; the first is to create the calendar

  setdate.d = DateVal("01-" + MOY(date.d) + "-" + STRVAL(YEAR(date.d)))
  clearline.a = SPACES(29)

  PROMPT " Use arrow keys to change calendar or press ESC to end ",""
  WHILE TRUE
    @ 2, 3
    ?? FORMAT("w30, ac", MOY(setdate.d)+ " " + STRVAL(YEAR(setdate.d))) ; display month
    STYLE ATTRIBUTE 79
    @ 18, 3 ?? FORMAT("w31,ac", "Today's date: " + STRVAL(TODAY()))
    STYLE

    test.a = DOW(setdate.d)                  ; finding out day of first day of month
    row.n = 6                                ; initializing other variables
    startday.n = 1

    SWITCH; set the first print position
      CASE test.a = "Sun":                   ; by the first day of the month
        startcol.n = 4
      CASE test.a = "Mon":
        startcol.n = 8
      CASE test.a = "Tue":
        startcol.n = 12
      CASE test.a = "Wed":
        startcol.n = 16
      CASE test.a = "Thu":
        startcol.n = 20
      CASE test.a = "Fri":
        startcol.n = 24
      CASE test.a = "Sat":
        startcol.n = 28
    ENDSWITCH

    month.a = MOY(setdate.d)                 ; find out month to tell how many
    SWITCH; days in month
      CASE month.a = "Sep" OR
        month.a = "Apr" OR
        month.a = "Jun" OR
        month.a = "Nov":
        lastday.n = 30
      CASE month.a = "Feb":
        test.a = DateVal("02/29/" + STRVAL(YEAR(setdate.d))) ; if the 29th is a
        IF test.a = "Error" THEN; valid date, then
          lastday.n = 28                                     ; it's a leap year
        ELSE; otherwise set it
          lastday.n = 29                                     ; to 28
        ENDIF
      OTHERWISE:                              ; if it's not Feb
        lastday.n = 31                        ; or a 30-day month
    ENDSWITCH; set to 31 days

    WHILE TRUE
      FOR x FROM startcol.n TO 28 STEP 4      ; print calendar
        @ row.n, x
        printdate.a = STRVAL(startday.n)
        IF LEN(printdate.a) = 1 THEN
          printdate.a = " " + printdate.a
        ENDIF
        ?? printdate.a
        startday.n = startday.n + 1              ; increment the day
        IF startday.n > lastday.n THEN; unless we're past the end of the month
          QUITLOOP
        ENDIF
      ENDFOR

      startcol.n = 4                           ; reset printing column
      row.n = row.n + 1                        ; advance to the next row
      IF startday.n > lastday.n THEN; unless we're past the end of
        QUITLOOP                               ; the month -- then leave
      ENDIF
    ENDWHILE

    WHILE TRUE                                 ; wait for user decision
      CURSOR OFF
      keystroke.n = GETCHAR ()
      SWITCH
        CASE keystroke.n = 27:                 ; program exit
          WINDOW CLOSE
          RETURN
        CASE keystroke.n = -75:               ; left -- for back a month
          IF MONTH(setdate.d) = 1 THEN; if it's Jan., also change year
            yer.a = STRVAL(YEAR(setdate.d) - 1)
          ELSE
            yer.a = STRVAL(YEAR(setdate.d))   ; otherwise it's the current year
          ENDIF
          prepdate.a = STRVAL(MONTH(setdate.d - 1)) + "/" + STRVAL(DAY(setdate.d)) + "/" + yer.a
                ; -------- above line builds new date string by changing month
          setdate.d = DateVal(prepdate.a)     ; change that string to a date
          QUITLOOP
        CASE keystroke.n = -77:               ; right -- for ahead a month
          IF MONTH(setdate.d) = 12 THEN; if it's Dec. change year
            yer.a = STRVAL(YEAR(setdate.d) + 1)
          ELSE
            yer.a = STRVAL(YEAR(setdate.d))
          ENDIF
          prepdate.a = STRVAL(MONTH(setdate.d+ 35)) + "/" + STRVAL(DAY(setdate.d)) + "/" + yer.a
          setdate.d = DateVal(prepdate.a)
          QUITLOOP
        OTHERWISE:                            ; different key was pressed
          BEEP
          LOOP
      ENDSWITCH

    ENDWHILE

    FOR clrline FROM 6 TO 11
      @ clrline, 3 ?? clearline.a
    ENDFOR

  ENDWHILE

ENDPROC
WRITELIB libname popcal.u
RELEASE PROCS popcal.u
