;ͻ
; Script: picktbl.sc      Creation Date: 11/1/92  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Presents a dialog box that allows the user to select a table   
; from those in the current directory                                         
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC picktable.a ()
  PRIVATE pickedfile.a, searchdir.a, buttonvalue

  searchdir.a = "*.db"                      ; filespec can be changed as needed
  pickedfile.a = ""

  SHOWDIALOG "Select a File to View"
    @5, 17 HEIGHT 16 WIDTH 44

    PICKFILE                                ; presents file list
      @ 0, 1
      HEIGHT 11 WIDTH 39
      COLUMNS 2
      searchdir.a
      NoExt
      TAG "FilePicked"
    TO pickedfile.a


    PUSHBUTTON                              ; OK button
      @12, 4 WIDTH 10
      "~V~iew"
      OK
      VALUE "View"
      TAG "View"
    TO buttonvalue

    PUSHBUTTON                              ; Cancel button
      @ 12, 26 WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "Cancel"
      TAG "Cancel"
    TO buttonvalue

ENDDIALOG

IF buttonvalue= "View" THEN                 ; returns filename
  RETURN pickedfile.a
ELSE                                        ; or blank if ESC or Cancel is pressed
  RETURN ""
ENDIF

ENDPROC
WRITELIB libname picktable.a
RELEASE PROCS picktable.a
