;ͻ
; Script: okbox.sc        Creation Date:09/21/92  Author: Jim Grinstead     
;                         Last Revision:          Revised By:               
;Ķ
; Description: Puts a one line message on the screen with headline and waits  
; for the user to press OK.                                                   
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                       evenodd.a                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC okbox.u (headline.a, text.a)
  PRIVATE width.n, headline.a, text.a, nullvar.v

  width.n = LEN(text.a)                       ; get length of text
  width.n = width.n + 3                       ; allow for borders and first space

  IF width.n < LEN(headline.a) + 10 THEN; make sure box is big enough for headline
    width.n = LEN(headline.a) + 10
  ENDIF

  IF evenodd.a(width.n) = "O" THEN; make sure there's a space at the end
    width.n = width.n + 1                    ; and that it's divisible by 2
  ENDIF

  SHOWDIALOG headline.a
    @ 8, 40 - (width.n / 2)
    HEIGHT 7 WIDTH width.n + 1               ; make it one wider than the text
    @1,0 ?? FORMAT("ac,w" + STRVAL(width.n),text.a) ; center text

    PUSHBUTTON; the OK button
      @ 3, (width.n / 2) - 6 WIDTH 10
      "~O~K"
      OK
      VALUE "OK"
      TAG "OK"
    TO nullvar.v
ENDDIALOG


ENDPROC
WRITELIB libname okbox.u
RELEASE PROCS okbox.u
