;ͻ
; Script: noise.sc        Creation Date: 11/23/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: A series of nine different noises that may be used in your     
; programs. Noises 8 and 9 will continue until a key is pressed.              
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC noise.u(choice.n)
  PRIVATE choice.n, x

  SWITCH

    CASE choice.n = 1:                ; brief noise, higher pitch
      SOUND 300 200

    CASE choice.n = 2:                ; brief noise, lower pitch
      SOUND 200 200

    CASE choice.n = 3:                ; briefer noise, lower pitch
      SOUND 200 100

    CASE choice.n = 4:                ; two brief higher pitched
      SOUND 300 100                ; attention sounds
      SOUND 30000 25
      SOUND 300 100

    CASE choice.n = 5:                ; up slider
      FOR x FROM 300 TO 400 STEP 25
        SOUND x 5
      ENDFOR

    CASE choice.n = 6:                ; European siren
      FOR x FROM 1 TO 3
        SOUND 530 500
        SOUND 200 500
      ENDFOR

    CASE choice.n = 7:                ; lower pitched slider
      FOR x FROM 130 TO 200 STEP 16
        SOUND x 5
      ENDFOR

    CASE choice.n = 8:                ; annoy user until a key is pressed
      WHILE NOT CHARWAITING ()
        SOUND 200 100
        SOUND 30000 200
        SOUND 200 100
        SOUND 30000 200
      ENDWHILE
      x = getchar ()

    CASE choice.n = 9:
      WHILE NOT CHARWAITING ()     ; annoy user at a higher pitch
        SOUND 300 75           ; and faster speed until key is pressed
        SOUND 30000 225
        SOUND 300 75
        SOUND 30000 225
      ENDWHILE
      x = getchar ()
  ENDSWITCH

ENDPROC
WRITELIB libname noise.u
RELEASE PROCS noise.u
