;ͻ
; Script: namekey.sc      Creation Date:12/15/91  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Generates a key based on an assumed last name and first name   
; field. By joining the two fields, the key allows a general sorting          
; alphabetically. The key uses the first eight letters of the last name and   
; the first four letters of the first name. In cases of duplicates, it trims  
; two letters from the last name and substitutes two digits at the end. Up    
; to 100 exact matches can be allowed this way. This was needed primarily in  
; Paradox 3.5 to keep names in sorted order. Ver 4.0 solved this problem with 
; its ability to set up views based on combined field indexes.                
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC namekey.a ()
  PRIVATE work.a, RETVAL, currentfield.a, test.l, place.n

  currentfield.a = FIELD()               ; mark current location in field
  place.n = RECNO ()                     ; and record

  work.a = SUBSTR([last name],1,8) + SUBSTR([first name],1,4)  ; get the key information

  HOME
  CtrlHome                               ; go to the top
  Right                                  ; of the first field

  WHILE true
    LOCATE work.a                        ; look for key
    test.l = RETVAL
; --------------------- if key exists, trim last two letters from last name
;                       portion of key. Then add random two digits at end of
;                       first name portion. Up to 100 dupes (00 to 99) can be
;                       handled this way. The routine will generate digits and
;                       check them until do duplicate is found.
    IF test.l THEN
      work.a = SUBSTR([last name],1,6) + SUBSTR([first name],1,4) + STRVAL(ROUND(RAND() * 100,0))
      LOOP
    ENDIF
    QUITLOOP
  ENDWHILE

  MOVETO RECORD place.n                ; return to previous record
  MOVETO FIELD currentfield.a          ; and field

  RETURN work.a                        ; return validated key
                                       ; key should be posted immediately
                                       ; on multi-user system to avoid problem
                                       ; of duplication
ENDPROC
WRITELIB libname namekey.a
RELEASE PROCS namekey.a
