;ͻ
; Script: lastfrst.sc     Creation Date:11/29/91  Author:J. Grinstead       
;                         Last Revision:          Revised By:               
;Ķ
; Description: Changes name such as John Doe to Doe, John. The script traps   
; for Jr., Sr, II, III and IV, but no other suffixes. Others can be added if  
; needed. The program will work name such as John Q. Doe.                     
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                       rtrim.a()                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC lastfirst.a (work.a)
  PRIVATE work.a, x, length.n, test.a, last.a, first.a

  work.a = rtrim.a(work.a)                  ; clean any trailing spaces

  length.n = LEN(work.a)

  FOR x FROM length.n TO 1 STEP -1          ; step backwards through the string
  test.a = SUBSTR(work.a, x, 1)
  IF test.a = " " THEN                      ; look for a space
    test.a = UPPER(SUBSTR(work.a, x + 1, 2))
    SWITCH                                  ; check for name suffixes
      CASE test.a = "JR" OR
        test.a = "SR" OR
        test.a = "II" OR
        test.a = "IV":
        x = x - 1
        LOOP
      OTHERWISE:                            ; if none, then flip names
        last.a = SUBSTR(work.a, x + 1, length.n - x)
        first.a = SUBSTR(work.a, 1, x - 1)
        work.a = last.a + ", " + first.a
        QUITLOOP
    ENDSWITCH
  ENDIF
  ENDFOR

  RETURN work.a

ENDPROC
WRITELIB libname lastfirst.a
RELEASE PROCS lastfirst.a
