;ͻ
; Script:keygen2.sc       Creation Date:12/16/91  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Generates a numerical key one larger than the largest number   
; in the field passed to the routine. If the column is blank, it assigns an   
; initial value of 100,000. The routine can then handle up to 999,999 entries.
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC keygen2.n (field.a)
  PRIVATE field.a, biggest.n

  biggest.n = CMax(TABLE (),field.a)    ; get the largest number in the field
                                        ; of the table on the workspace
  IF biggest.n = "Error" THEN           ; if there is no value, assign 100,000
    biggest.n = 100000
  ELSE
    biggest.n = biggest.n + 1           ; if there is, increment it by one
  ENDIF

  RETURN biggest.n                      ; return the value

ENDPROC
WRITELIB libname keygen2.n
RELEASE PROCS keygen2.n
