;ͻ
; Script: keygen.sc       Creation Date: 12/16/91 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Generates a random number key. The routine generates the       
; number then scans through the named field to determine if there is a        
; duplicate. If so, it generates another number until one is found that       
; is unique.                                                                  
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC keygen1.n ()
  PRIVATE record.n, newkey.n, currentfield.a

  currentfield.a = FIELD ()           ; remember current field
  record.n = RECNO ()                 ; and record number

  Home                                ; go to key field
  CtrlHome
  IF FIELD () = "#" THEN
    Right
  ENDIF

  WHILE TRUE
    newkey.n = ROUND(RAND () * 1000000,0)   ; generate random number
    LOCATE newkey.n                   ; search for duplicate
    IF RETVAL THEN
      QUITLOOP                       ; if none, exit
    ENDIF
  ENDWHILE

  MOVETO FIELD currentfield.a               ; return to original field
  MOVETO RECORD record.n                    ; and record

  RETURN newkey.n

ENDPROC
WRITELIB libname keygen1.n
RELEASE PROCS keygen1.n
