;ͻ
; Script: incre.sc        Creation Date:04/17/92  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: A routine to increment a string of text. The routine will      
; increment the last letter and preceding letters as necessary. Numbers may be
; included. If all increments have been taken -- such as ZZZZZ or 99999, the  
; routine returns a null string.                                              
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC increment.a (value.a)
  PRIVATE value.a, length.n, okay.n, test.n, x

  length.n = LEN(value.a)

  FOR x FROM length.n TO 1 STEP -1
  test.n = ASC(SUBSTR(value.a, x, 1))
  SWITCH
    CASE x = 1 AND UPPER(CHR(test.n)) = "Z":
      RETURN ""
    CASE x = 1 AND test.n = 57:
      RETURN ""
    CASE test.n = 90:                       ; Z moves to A
      test.n = 65
    CASE test.n = 122:                      ; z moves to a
      test.n = 97
    CASE test.n = 57:                       ; 9 moves to 0
      test.n = 48
    OTHERWISE:                              ; moves to the next ASCII value
      test.n = test.n + 1
      okay.n = 1                            ; exit flag
  ENDSWITCH
  value.a = SUBSTR(value.a, 1, x - 1) + CHR(test.n) + SUBSTR(value.a, x + 1, length.n - x)
  IF ISASSIGNED(okay.n) THEN
    QUITLOOP
  ENDIF
  ENDFOR

  RETURN value.a

ENDPROC
WRITELIB libname increment.a
RELEASE PROCS increment.a
