;ͻ
; Script: getssn2.sc      Creation Date: 11/30/91 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Gets a social security number in a more elegant way than is    
; is possible with an ACCEPT statement.                                       
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC getssn2.a ()
  PRIVATE row.n, col.n, entry.n, x, ssn.a

  row.n = ROW ()                               ; fix current locations
  col.n = COL ()

  ssn.a = ""

  @ row.n, col.n ?? "___-__-____"              ; print form for user to see

  FOR x FROM col.n TO col.n + 11              ; going one past length to allow for ENTER press to return
  @ row.n, x
  WHILE true
    entry.n = GETCHAR ()

    SWITCH
      CASE entry.n = 27:                      ; ESC key
        RETURN "ESC"
      CASE entry.n = 8:                       ; Backspace key
        SWITCH
          CASE x = col.n + 4:                         ; handle moving from middle back to prefix
            x = col.n + 1
          CASE x = col.n + 7:                        ; handle moving from suffix to middle
            x = col.n + 4
          CASE x = col.n:                         ; don't move past beginning of line
            LOOP
          OTHERWISE:                          ; move back. It's two because the loop will increment later
            x = x - 2
        ENDSWITCH
        ssn.a = SUBSTR(ssn.a, 1, LEN(ssn.a) - 1) ; trim off the old number
        QUITLOOP
      CASE x = col.n + 11:                    ; this allows user to press ENTER
        IF entry.n <> 13 THEN; to leave routine at the end
          LOOP                            ; any other key is rejected
        ELSE
          QUITLOOP                        ; it's ENTER, so bail out
        ENDIF
      CASE entry.n < 48 OR entry.n > 57:      ; not a number, so don't accept
        BEEP
        LOOP
      OTHERWISE:                              ; must be a number, so accept
        ?? CHR(entry.n)
        ssn.a = ssn.a + CHR(entry.n)          ; add to number list
        QUITLOOP
    ENDSWITCH
  ENDWHILE

  SWITCH; moving cursor
    CASE x + 1 = col.n + 3:                   ; past prefix into middle
      x = x + 1
    CASE x + 1 = col.n + 6:                   ; or from middle to suffix
      x = x + 1
  ENDSWITCH

  ENDFOR
                                            ;below we format our string of numbers
  ssn.a = SUBSTR(ssn.a, 1, 3) + "-" + SUBSTR(ssn.a, 4, 2) + "-" + SUBSTR(ssn.a, 6,4)

  RETURN ssn.a                               ; return the formatted string

ENDPROC
WRITELIB libname getssn2.a
RELEASE PROCS getssn2.a
