;ͻ
; Script: getdate2.sc     Creation Date:11/24/91  Author:J. Grinstead       
;                         Last Revision:          Revised By:               
;Ķ
; Description: More visual way of getting date from current cursor position   
; than allowed through ACCEPT.                                                
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC getdate2.d ()
  PRIVATE row.n, col.n, date.a, test.d, x, entry.n

  row.n = ROW ()
  col.n = COL ()

  WHILE true
    date.a = ""

    @ row.n, col.n ?? "__/__/__"

    FOR x FROM col.n TO col.n + 8
    @ row.n, x
    WHILE true
      entry.n = GETCHAR ()

  SWITCH
    CASE entry.n = 27:                      ; ESC key
      RETURN "ESC"
    CASE entry.n = 8:                       ; Backspace key
      SWITCH
        CASE x = col.n + 3:                         ; handle moving from day back to month
          x = col.n
        CASE x = col.n + 6:                        ; handle moving from year to day
          x = col.n + 3
        CASE x = col.n:                         ; don't move past beginning of line
          LOOP
        OTHERWISE:                          ; move back. It's two because the loop will increment later
          x = x - 2
      ENDSWITCH
      date.a = SUBSTR(date.a, 1, LEN(date.a) - 1) ; trim off the old number
      QUITLOOP
    case x = col.n + 8:                     ; this allows user to press ENTER
         if entry.n <> 13 then              ; to leave routine at the end
            loop                            ; any other key is rejected
         else
            quitloop                        ; it's ENTER, so bail out
         endif
    CASE entry.n < 48 OR entry.n > 57:      ; not a number, so don't accept
      BEEP
      LOOP
    OTHERWISE:                              ; must be a number, so accept
      ?? CHR(entry.n)
      date.a = date.a + CHR(entry.n)        ; add to number list
      QUITLOOP
  ENDSWITCH
ENDWHILE
    SWITCH
      CASE x + 1 = col.n + 2:
        x = x + 1
      CASE x + 1 = col.n + 5:
        x = x + 1
    ENDSWITCH

    ENDFOR

    date.a = SUBSTR(date.a, 1, 2) + "/" + SUBSTR(date.a, 3, 2) + "/" + SUBSTR(date.a, 5, 2)

    test.d = DateVal(date.a)

    IF test.d = "Error" THEN           ; could cause a problem if errorproc is
      MESSAGE " No such date "         ; defined. Be sure errorproc simply returns
      BEEP BEEP BEEP                   ; if error 30 occurs.
      LOOP
    ELSE
      QUITLOOP
    ENDIF

  ENDWHILE

  RETURN test.d

ENDPROC
WRITELIB libname getdate2.d
RELEASE PROCS getdate2.d
