;ͻ
; Script: fullname.sc     Creation Date: 12/14/91 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Returns the full pathname of a file or table. Styl determines  
; if slashes will be single or double.                                        
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC fullname.a (work.a, styl.n)
  PRIVATE work.a, styl.n, place.l, ok, new.a

  work.a = DIRECTORY () + work.a

  IF styl.n = 0 THEN                        ; double slashes preferred
    new.a = ""
    WHILE true
      ok = MATCH(work.a, "..\\..", left.a, right.a)   ; find slash
      IF ok THEN
        work.a = left.a + new.a + right.a             ; replace with unique character
      ELSE
        QUITLOOP
      ENDIF
    ENDWHILE

    new.a = "\\\\"
    WHILE true
      ok = MATCH(work.a, "....", left.a, right.a)    ; find unique character
      IF ok THEN
        work.a = left.a + new.a + right.a             ; replace with double slashes
      ELSE
        QUITLOOP
      ENDIF
    ENDWHILE

  ENDIF

  RETURN work.a

ENDPROC
WRITELIB libname fullname.a
RELEASE PROCS fullname.a
