;ͻ
; Script: findtblb.sc     Creation Date: 11/15/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Searches backwards through a string to find the first          
; occurance of a string listed in the table.a variable. If not found, zero is 
; return.                                                                     
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC findtableb.n (start.n, source.a, table.a)
  PRIVATE source.a, table.a, start.n, test.a, place.n, x, y

  IF NOT IsAssigned(start.n) THEN
    start.n = LEN(source.a)
  ENDIF

  trips.n = LEN(table.a)
  FOR x FROM 1 TO trips.n
    test.a = SUBSTR(table.a, x, 1)
    FOR y FROM start.n TO 1 STEP -1
      IF UPPER(test.a) = UPPER(SUBSTR(source.a, y, 1)) THEN
        RETURN y
      ENDIF
    ENDFOR
  ENDFOR

  RETURN 0

ENDPROC
WRITELIB libname findtableb.n
RELEASE PROCS findtableb.n
