;ͻ
; Script: findtbl.sc      Creation Date: 11/15/92 Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: Searches through a string to find the first occurance of a     
; string listed in the table variable. The routine returns zero if no         
; value is found.                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC findtable.n (start.n, source.a, table.a)
  PRIVATE source.a, table.a, start.n, test.a, place.n, x

  IF NOT IsAssigned(start.n) THEN
    start.n = 1
  ENDIF

  trips.n = LEN(table.a)
  FOR x FROM 1 TO trips.n
    test.a = SUBSTR(table.a, x, 1)
    place.n = SEARCHFROM(test.a, source.a, start.n)
    IF place.n > 0 THEN
      RETURN place.n
    ENDIF
  ENDFOR

  RETURN 0

ENDPROC
WRITELIB libname findtable.n
RELEASE PROCS findtable.n
