;ͻ
; Script: delrec.sc       Creation Date: 11/2/92  Author: J. Grinstead      
;                         Last Revision:          Revised By:               
;Ķ
; Description: User a dialog box to confirm with the user that the record is  
; to be deleted. The routine works in main, edit or coedit modes. It stores   
; the most recently erased record in memory and it can be restored even after 
; the edit session ends with the use of the companion restorerec routine.     
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                                                        
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC delrec.u ()
  PRIVATE delok.a, test.a

  SHOWDIALOG "Delete Record?"
    @ 9, 24 HEIGHT 5 WIDTH 32

    PUSHBUTTON
      @ 1, 2 WIDTH 10
      "~Y~es"
      OK
      VALUE "OK"
      TAG "OK"
    TO delok.a

    PUSHBUTTON
      @ 1, 17 WIDTH 10
      "~N~o"
      CANCEL
      VALUE "NO"
      TAG "NO"
    TO delok.a

ENDDIALOG

IF RETVAL = FALSE THEN; see if user pressed ESC
  RETURN FALSE                      ; return a false value if needed
ENDIF

SWITCH
  CASE delok.a = "Yes":              ; inform user
    MESSAGE " Deleting record . . . "
  CASE delok.a = "":              ; return false if needed
    RETURN FALSE
ENDSWITCH

CopyToArray a$$!.r                   ; send to array so it can be recovered

test.a = UPPER(SYSMODE())             ; determine mode

SWITCH
  CASE test.a = "MAIN":               ; if main, switch into coedit, delete
    CoEdit TABLE ()
    DEL
    Do_It!; then return to main mode
  OTHERWISE:
    DEL                               ; must be in edit or coedit, so delete
ENDSWITCH

;----------- NOTE: Above code will not protect user being in create, form or other modes
;            it is up to the programmer to prevent this routine from being called
;            unless the user is in either main, edit or coedit mode.

ENDPROC
WRITELIB libname delrec.u
RELEASE PROCS delrec.u
