;ͻ
; Script: compstrc.sc     Creation Date: 11/7/92  Author:J. Grinstead       
;                         Last Revision:          Revised By:               
;Ķ
; Description:  Compares the structure of two tables and returns true of they 
; are alike and false if they are different.                                  
;                                                                             
;                                                                             
;                                                                             
;Ķ
; Called By:                                                                  
;Ķ
; Libraries:                                                                  
;Ķ
; Tables    Forms    Reports  Scripts   Procedures         External Pgms 
;Ķ
;                                       uniquename.a                     
;                                                                        
;                                                                        
;                                                                        
;Ķ
;Notes: Copyright 1993 Jim Grinstead                                          
;                                                                             
;ͼ

PROC comparestruct.l(table1.a, table2.a)
  PRIVATE table1.a, table2.a, t1name.a, t2name.a, test.a

  Menu                                      ; get a structure table
  {TOols}
  {INFO}
  {structure}
  SELECT table1.a

  t1name.a = uniquename.a ()                ; get a unique name for the table
  t2name.a = uniquename.a ()

  RENAME "struct" t1name.a                  ; rename the table so we don't overwrite

  Menu                                      ; get structure of second table
  {tools}
  {info}
  {structure}
  SELECT table2.a

  RENAME "struct" t2name.a                  ; rename it

  MOVETO t1name.a
  MOVETO [field type]
  SCAN                                      ; move to first structure table
    test.a = []                             ; get contents
    MOVETO t2name.a
    MOVETO [field type]
    IF test.a <> [] THEN                    ; compare with second table
      DELETE t2name.a
      DELETE t1name.a
      RETURN FALSE                          ; if no match, clean up and go home
    ELSE
      Down                                  ; position for next comparison
      MOVETO t1name.a                       ; return to original table
      MOVETO [field type]
    ENDIF
  ENDSCAN

  DELETE t2name.a                           ; were successful, so clean up
  DELETE t1name.a

  RETURN TRUE                               ; and return true

ENDPROC
WRITELIB libname comparestruct.l
RELEASE PROCS comparesturct.l
