unit Grphfunc;

interface

uses WinTypes,
     WinProcs,
     Strings,
     _GrpFunc; { This contains identifiers }

{$R grphfunc.res}

const
  bxs_3DEx = 1;  { 3D Extruding Box }
  bxs_3DIn = 2;  { 3D Concave Box   }

const
  digit_Point = 1; { Pointed middles   }
  digit_Flat = 2;  { Flattened middles }

procedure DrawBox(DC: HDC; Location: TRect; Style: Integer);
procedure LCD(DC: HDC; Location: TPoint; Text: PChar; Style: Integer);

implementation

{ ---------------------------------------------------------------------------------------------------- ****** DrawBox ****** }

{ This procedure draws a box on the supplied DC, with shadows 2 pixels thick showing
  either intrusion or extrusion }
procedure DrawBox(DC: HDC;         { This DC is painted on }
                  Location: TRect; { This defines the outside pixels of the box }
                  Style: Integer); { A bxs_ constant specifying an intruding of extruding box }
var
  Pen1,
  Pen2,
  MemPen : THandle;
begin
{ First the function creates dark and light pens, depending on which constant was supplied }
  case Style of
    bxs_3DEx: begin Pen1 := CreatePen(ps_Solid, 0, RGB(64, 64, 64)); Pen2 := GetStockObject(White_Pen); end;
    bxs_3DIn: begin Pen2 := CreatePen(ps_Solid, 0, RGB(64, 64, 64)); Pen1 := GetStockObject(White_Pen); end;
  end;
  with Location do begin
{ This bit draws the left and top borders with the pens created above }
    MemPen := SelectObject(DC, Pen2);
      MoveTo(DC, left, bottom);
      LineTo(DC, left, top);
      LineTo(DC, right, top);

      LineTo(DC, right - 1, top + 1);
      LineTo(DC, left + 1, top + 1);
      LineTo(DC, left + 1, bottom - 1);
{ And this section draws the right and bottom sections }
    SelectObject(DC, Pen1);
      MoveTo(DC, left, bottom);
      LineTo(DC, right, bottom);
      LineTo(DC, right, top);

      LineTo(DC, right - 1, top + 1);
      LineTo(DC, right - 1, bottom - 1);
      LineTo(DC, left + 1, bottom - 1); 
{ And the DC is returned to it's original state }
    SelectObject(DC, MemPen);
  end;
{ The pens are destroyed }
  DeleteObject(Pen1);
  DeleteObject(Pen2);
end;

{ -------------------------------------------------------------------------------------------------------- ****** LCD ****** }
procedure LCD(DC: HDC;
              Location: TPoint;
              Text: PChar;
              Style: Integer);
var
  MemDC,
  BMemDC:      HDC;
  Bitmap,
  BitmapBlank: HBitmap;
  Code:        Byte;
  Pos,
  YPos,
  XPos:        Integer;
  Pen,
  MemPen:      HPen;
  Brush,
  MemBrush:    HBrush;
begin
  Bitmap := LoadBitmap(HInstance, PChar(Style));
  BitmapBlank := LoadBitmap(HInstance, PChar(Style + 2));
    MemDC := CreateCompatibleDC(DC);
    BMemDC := CreateCompatibleDC(DC);
      SelectObject(MemDC, Bitmap);
      SelectObject(BMemDC, BitmapBlank);
      Pos := Location.X;

      Brush := GetStockObject(Black_Brush);
      Pen := GetStockObject(Black_Pen);
      MemBrush := SelectObject(DC, Brush);
      MemPen := SelectObject(DC, Pen);
      Rectangle(DC, Location.X - 2, Location.Y - 2, Location.X + (18 * StrLen(Text)), Location.Y + 31);
      SelectObject(DC, MemBrush);
      SelectObject(DC, MemPen);

      while StrComp(Text, '') <> 0 do
      begin
        Code := Byte(Text^);
        if ((Code >= 48) or (Code <= 57) or (Code = 32)) then
        begin
          if Code = 32 then
            BitBlt(DC, Pos, Location.Y, 16, 29, BMemDC, 0, 0, SrcCopy)
          else begin
            Code := Code - 48;
            if Code > 4 then
              YPos := 29
            else
              YPos := 0;
            XPos := (Code mod 5) * 16;
            BitBlt(DC, Pos, Location.Y, 16, 29, MemDC, XPos, YPos, SrcCopy);
          end;
          Inc(Text);
          Pos := Pos + 18;
        end;
      end;
    DeleteDC(MemDC);
    DeleteDC(BMemDC);
  DeleteObject(Bitmap);
  DeleteObject(BitmapBlank);
end;

end. { End of file }