unit DOSFunc;

{ uses dialogs number 101 }

interface{@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Interface }

{************************************************************************************************** Uses }
uses WinDos,
     Strings,
     WObjects,
     WinTypes,
     WinProcs,
     Win31,
     _dosfunc;

{$R dosfunc.res}

{************************************************************************************************** Public Methods }
{======================================================================================== Get }
procedure Get(Wanted: Integer; Buff: PChar);
const
  g_CurDrive = 1;
  g_CurPath = 2;
{======================================================================================== FileDlg }
function FileDlg(Wnd: PWindowsObject; FileName, StartPath, Title: PChar; Style: Integer): Integer;
const
  fd_Open = 101;
  fd_Save = 102;

implementation{@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Implementation }

{************************************************************************************************** Get }
procedure Get(Wanted: Integer; Buff: PChar);
{ eg: Get(g_CurPath, Buff); }
var
  Path,
  Dir,
  Name: Array[0..100] of Char;
  Ext:  Array[0..3] of Char;
begin
  GetCurDir(Path, 0);
  FileSplit(Path, Dir, Name, Ext);
  case Wanted of
    g_CurDrive:
      begin
        Path[2] := #0;
        StrCopy(Buff, Path);
      end;
    g_CurPath:
      begin
        StrCopy(Buff, Path);
      end;
  end;
end;

{************************************************************************************************** FileDlg }
var
  FName: Array[0..12] of Char;

type
  PFileDialog = ^TFileDialog;
  TFileDialog = object(TDialog)
    Style: Integer;
    Title: Array[0..50] of Char;
    Path: Array[0..150] of Char;
    constructor Init(AParent: PWindowsObject; AStyle: Integer; ATitle, APath: PChar);
    procedure SetupWindow; virtual;
    procedure WMCommand(var Msg: TMessage); virtual wm_First + wm_Command;
  end;

constructor TFileDialog.Init(AParent: PWindowsObject; AStyle: Integer; ATitle, APath: PChar);
begin
  TDialog.Init(AParent, PChar(AStyle));
  Style := AStyle;
  StrCopy(Path, APath);
  StrCopy(Title, ATitle);
end;

procedure TFileDialog.SetupWindow;
begin
  TDialog.SetUpWindow;
  SetWindowText(HWindow, Title);
  DlgDirListComboBox(HWindow, Path, dlg_Open_Files, dlg_Open_CDir, ddl_ReadWrite);
  DlgDirList(HWindow, Path, dlg_Open_Dirs, dlg_Open_CDir, ddl_Directory or ddl_Exclusive);
end;

procedure TFileDialog.WMCommand(var Msg: TMessage);
var
  t1: Array[0..150] of Char;
  p1, p2: PChar;
  i1: Integer;
begin
  case Msg.wParam of
    dlg_Open_Dirs:
      case Msg.lParamHi of
        lbn_DblClk:
          begin
            p1 := t1;
            i1 := SendDlgItemMessage(HWindow, dlg_Open_Dirs, lb_GetCurSel, 0, 0);
            SendDlgItemMessage(HWindow, dlg_Open_Dirs, lb_GetText, i1, LongInt(@t1));
            Inc(p1);
            p2 := StrRScan(t1, ']');
            StrCopy(p2, '');
            SetCurDir(p1);
            DlgDirListComboBox(HWindow, Path, dlg_Open_Files, dlg_Open_CDir, ddl_ReadWrite);
            DlgDirList(HWindow, Path, dlg_Open_Dirs, dlg_Open_CDir, ddl_Directory or ddl_Exclusive);
          end
      else
        TDialog.WMCommand(Msg);
      end;
    dlg_Open_Files:
      case Msg.lParamHi of
        cbn_DblClk:
          begin
            GetDlgItemText(HWindow, dlg_Open_Files, FName, 12);
            EndDialog(HWindow, id_OK);
          end;
        cbn_EditChange:
          GetDlgItemText(HWindow, dlg_Open_Files, FName, 12);
      else
        TDialog.WMCommand(Msg);
      end;
    id_OK:
      case Msg.lParam of
        bn_Clicked:
          begin
            GetDlgItemText(HWindow, dlg_Open_Files, FName, 12);
            EndDialog(HWindow, id_OK);
          end;
       else
         TDialog.WMCommand(Msg);
       end;
  else
    TDialog.WMCommand(Msg);
  end;
end;

function FileDlg(Wnd: PWindowsObject; FileName, StartPath, Title: PChar; Style: Integer): Integer;
var
  FileDialog: PFileDialog;
begin
  FileDialog := New(PFileDialog, Init(Wnd, Style, Title, StartPath));          
  FileDlg := FileDialog^.Execute;
  Dispose(FileDialog, Done);
  FileExpand(FileName, FName);
end;

begin
end.