;========================================================================

; Copyright (C) 1991 by Jan.Engvald@ldc.lu.se, see file COPYING.

InAdrArpa	db	7,"in-addr",4,"arpa",0
Qtype		dw	0c00h
Qclass		dw	0100h
InAdrArpaLen	equ	$-InAdrArpa

k16		dw	16
TblSize 	dw	16
TblSizeLast	dw	16*16
TblLineLen	dw	72			; (new format is 81)
TblActive	dw	0
TblActLast	dw	0
TblWrNext	dw	0
TblIpProbe	dw	130+256*235, 132+256*0
TblProbeNext	dw	0
TblProbIntvl	dw	9
TblSeen 	dw	0, 0

TmpTbl		dw	0, 0, 0, 0, 0, 0, 0

SegmData	equ	$
SegIpHwTbl	dw	0
SegHwIpTbl	dw	0
SegmNamTbl	dw	0
SegmNamTbl2	dw	0
TableSegs	equ	($-SegmData)/2

Slot		struc				; structure for SegIpHwTbl
SlotIp		dw	0, 0
SlotHw		dw	0, 0, 0
SlotDupl	db	'>'
SlotPend	db	'p'
SlotNamPtr	dw	0
SlotSeen	dw	0
Slot		ends

Handle		dw	-1
if DEBUG
NameHwTbl	db	"hwtbl.tst", 0
NameIpTbl	db	"iptbl.tst", 0
else
NameHwTbl	db	"hwtbl.txt", 0
NameIpTbl	db	"iptbl.txt", 0
endif ; DEBUG

MsgTblSize      db      "Wrote    0 table entries, "
MsgTblAct       db      "   0 active this run.", CR, LF, '$'

TblTime         dw      0, 0, 0, 0

		align	16
MsgTblDispl     db      60 dup (' ')
MsgTblSeen      db      11 dup (' ')
MsgTblTime	db	"00:00:00", CR, '$'
 


;************************************************************************
;*		TblDisplay 
;************************************************************************

TblDisplay	proc	near
		assume	ds:code_s
		push	cs
		pop	es
		mov	ah,2Ch			; get time
		int	21h
		mov	di,offset TblTime
		mov	si,di
		cld
		mov	al,ch
		cbw
		stosw
		mov	al,cl
		cbw
		stosw
		mov	al,dh
		cbw

		cmp	ax,[di] 		; new second yet?
		jne	TblNewTime
		ret

  TblNewTime:
		stosw

		mov	ch,':'
		mov	cl,3
		mov	di,offset MsgTblTime
		call	PutNumsD2F0 		; put time of day

		mov	ax,TblSeen
		mov	dx,TblSeen+2
		mov	di,offset MsgTblSeen
		mov	PutNumFiller,' '
		mov	PutMinDigits,10
		call	PutBigNum		; put ARP broadcasts seen

		mov	dx,offset MsgTblDispl
		call	DosPr$
		ret
TblDisplay	endp



;************************************************************************
;*		FindIn16Table
;*
;*	Input:	     DS:SI = address of search string key (saved)
;*			AX = string length (saved)
;*			ES = table segment (saved)
;*			BX = table size in bytes
;*	Output:      ES:BX = table slot address of entry less or equal to key
;*			Zero flag if equal to key
;*	Destroys:	BX, flags
;*
;* Before use, the table must be filled with all ones, except slot 0 which
;* must be filled with zeros. Slot 0 may never be changed.
;************************************************************************

FindIn16Table	proc	near
		assume	ds:nothing
		push	cx
		push	dx
		push	di
		push	bp
		mov	bp,si
		mov	cx,bx
		xor	bx,bx
		mov	dx,8000h		; find proper 2**x size
  FindLenLoop:
		cmp	dx,cx
		jb	FindHalfChk		; start binary search
		shr	dx,1
		jmp	short FindLenLoop

  FindLess:
		sub	bx,dx
  FindGreater:
		shr	dx,1			; divide step by two
  FindHalfChk:
		cmp	dx,16			; step < slot size?
		jb	FindDone
		add	bx,dx			; position halfway

		mov	di,bx
		mov	si,bp
		mov	cx,ax
		repe	cmpsb			; compare strings
		ja	FindGreater
		jb	FindLess
  FindDone:
		mov	si,bp
		pop	bp
		pop	di
		pop	dx
		pop	cx
		ret
FindIn16Table	endp



;************************************************************************
;*		GetHexNums
;************************************************************************

GetHexNums	proc	near
		assume	ds:nothing
  GetHexNum:
		xor	dx,dx
  GetHexDig:
		lodsb
		cmp	al,'0'
		jb	GetHexEnd
		cmp	al,'9'
		ja	GetHexTst
		sub	al,'0'
		jmp	short GetHexConv
  GetHexTst:
		cmp	al,'a'
		jb	GetHexEnd
		cmp	al,'f'
		ja	GetHexEnd
		sub	al,'a'-10
  GetHexConv:
		cbw
		add	ax,dx
		mov	cx,ax
		mul	k16
		mov	dx,ax
		jmp	short GetHexDig
  GetHexEnd:
		cmp	al,'-'
		mov	ax,cx
		stosb
		je	GetHexNum
		ret
GetHexNums	endp



;************************************************************************
;*		Ins16ByteSlot
;************************************************************************

Ins16ByteSlot	proc	near
		SHOW_EVENT	'a'
		assume	ds:nothing
		push	ds
		mov	cx,cs:TblSize
		push	es
		pop	ds
		sub	cx,bx
		mov	si,bx
		sub	si,2
		add	si,cx
		mov	di,si
		add	di,16
		std
		shr	cx,1
		rep	movsw
		cld
		pop	ds
		ret
Ins16ByteSlot	endp



;************************************************************************
;*		FindHostInTbls
;************************************************************************

FindHostInTbls	proc	near
		assume	ds:nothing
		push	dx
		push	ax

		mov	es,cs:SegHwIpTbl
		mov	bx,cs:TblSize
		mov	ax,11
		mov	si,bp
		push	[si+10]
		mov	byte ptr [si+10],' '
		call	FindIn16Table
		pop	[si+10]
		jz	InitHwMatch

		add	bx,16
		call	Ins16byteSlot
		mov	si,bp
		mov	cx,10/2
		mov	di,bx
		rep	movsw			; (SlotHw SlotIp)

		mov	ax,'  '
		stosw				; SlotDupl SlotPend
		mov	ax,TblSize
		stosw				; SlotNamPtr
  InitHwMatch:
		mov	es,SegIpHwTbl
		mov	bx,cs:TblSize
		mov	ax,11
		mov	si,bp
		sub	si,4
		push	[si+10]
		mov	byte ptr [si+10],' '
		call	FindIn16Table
		pop	[si+10]
		jz	InitIpMatch

		add	bx,16
		call	Ins16byteSlot
		mov	si,bp
		sub	si,4
		mov	cx,10/2
		mov	di,bx
		rep	movsw			; SlotIp SlotHw

		mov	ax,'  '
		stosw				; SlotDupl SlotPend
		mov	ax,cs:TblSize
		stosw				; SlotNamPtr
		xor	ax,ax
		stosw				; SlotSeen
		or	sp,sp
  InitIpMatch:
		pushf
		test	cs:GenFlags,PROBE_REPLY
		jnz	FindHostProbe

		inc	es:[bx].SlotSeen
		add	cs:TblSeen,1
		adc	cs:TblSeen+2,0
  FindHostProbe:
		popf
		pop	ax
		pop	dx
		ret
FindHostInTbls	endp



;************************************************************************
;*		TableInit
;************************************************************************

TableInit	proc	near
		assume	ds:code_s
		test	Argflags,MAKE_TABLE
		jnz	TableInit2
		ret
  TableInit2:
		mov	bx,(TableSegs-1)*2
		mov	dx,cs
		add	dx,1000h
		mov	ax,'  ' 		; NamTbl2 must be blanked
  TableFF:
		mov	word ptr SegmData[bx],dx
		mov	es,dx
		add	dx,1000h
		cmp	dx,PspTopMem		; end of free memory?
		jbe	TableFits

		mov	al,'M'-'0'
		call	Terminate
  TableFits:
		mov	cx,08000h		; prefill all 64 kb
		xor	di,di
		rep	stosw

		sub	bx,2
		mov	ax,0ffffh		; IpHwTbl prefill
		jns	TableFF

		xor	ax,ax			; zerofill first slot
		mov	es,SegIpHwTbl
		mov	cx,16/2
		xor	di,di
		rep	stosw

		mov	es,SegHwIpTbl
		mov	cx,16/2
		xor	di,di
		rep	stosw

		push	cs
		pop	es

		mov	dx,offset NameHwTbl
		mov	ax,3d02h
		int	21h
		jc	TabInitHw

		mov	bx,ax
		mov	ah,3eh
		int	21h
		jmp	TabTstIp
  TabInitHw:
		mov	dx,offset NameHwTbl
		xor	cx,cx
		mov	ah,3ch
		int	21h
		jc	TabOpenErr
  TabTstIP:
		mov	dx,offset NameIpTbl
		mov	ax,3d02h
		int	21h
		mov	Handle,ax
		jnc	TabRdNext

		mov	dx,offset NameIpTbl
		xor	cx,cx
		mov	ah,3ch
		int	21h
		jc	TabOpenErr
		jmp	TabRdClOK
  TabOpenErr:
		mov	al,'O'-'0'
		call	Terminate

  
  TabRdLong:
		mov	TblLineLen,81
		mov	cx,9
		mov	dx,offset FileBuf+72
		jmp	short TabRdMore
  
  TabRdNext:
		push	cs
		pop	es
		mov	cx,TblLineLen
		mov	dx,offset FileBuf
  TabRdMore:		    
		mov	bx,Handle
		mov	ah,3fh
		int	21h
		jc	TabRdErr

		mov	si,offset FileBuf
		cmp	byte ptr [si],'Z'-040h
		je	TabRdEof
	        
		or	ax,ax
		jz	TabRdEof

		cmp	TblLineLen,72
		jne	TabOkLen

		cmp	byte ptr FileBuf+71,LF
		jne	TabRdLong
  TabOkLen:
		mov	di,offset TmpTbl
		mov	bp,di
		call	GetIpNr
		jnz	TabRdErr

		mov	si,offset FileBuf+53
		call	GetHexNums

		push	si
		mov	si,bp
		movsw
		movsw

		add	bp,4
		call	FindHostInTbls
		je	InitDup

		push	es
		mov	si,offset FileBuf+16
		mov	di,TblSize
		call	NamePut
		add	TblSize,16
		pop	es
  InitDup:
		pop	si
		cmp	byte ptr [si],LF
		je	TabRdOld

		call	Skip_Blanks
		call	GetNum
		dec	ax
		cwd
		add	es:[bx].SlotSeen,ax
		add	TblSeen,ax
		adc	TblSeen+2,dx
		inc	si
  TabRdOld:
		push	cs
		pop	es
	        
		cmp	byte ptr [si],LF
		jne	TabRdErr

		mov	byte ptr [si+1],'$'

		mov	dx,offset FileBuf
		call	DosPr$
		jmp	TabRdNext

  TabRdErr:
		mov	al,'R'-'0'
		call	Terminate

  TabRdEof:
		mov	bx,Handle
		mov	ah,3eh
		int	21h
		jnc	TabRdClOK

		mov	al,'C'-'0'
		call	Terminate
  TabRdClOK:
if DEBUG eq 0
		call	ProbeIpInit
endif ; not DEBUG
		mov	cx,SavedTicks
		mov	TblProbeNext,cx
		mov	TblWrNext,cx
		cmp	EchoTarget,0
		jnz	TableInitRet

TableReady:
		or	GenFlags,TBL_READY
		mov	si,offset DefGwyNum
		lodsw
		mov	cx,ax
		jcxz	TableInitRet
  TableGwyLoop:
		push	cx
		lodsw
		mov	dx,ax
		lodsw
		push	si
		push	ds
		push	es
		call	BufAlloc
		mov	[bx].dTimOutMsg,0	; we don't require an answer
		mov	[bx].dTickTimeout,0	; don't wait
		call	SendArpReq		; send arp
		call	BufRelease
		pop	es
		pop	ds
		pop	si
		pop	cx
		loop	TableGwyLoop

  TableInitRet:
		ret
TableInit	endp



ProbeIpInit	proc	near
		mov	dx,MyNet
		mov	ax,Mynet+2
		mov	TblIpProbe,dx
		inc	ah
		mov	TblIpProbe+2,ax
		ret
ProbeIpInit	endp



;************************************************************************
;*		TblProbe
;************************************************************************

MsgNeedMask	db	"Need to know network mask", CR, LF, '$'

TblProbe	proc	near
		assume	ds:nothing
		mov	ds,cs:MySegm
		assume	ds:code_s
		cmp	InSendAndW,0
		jnz	TblProbeRet

		test	GenFlags,TBL_READY
		jz	TblProbeRet

		mov	cx,SavedTicks
		mov	ax,cx
		sub	ax,TblProbIntvl 	; 2 - 9 probes a second
		sub	ax,TblProbeNext
		js	TblProbeRet

		mov	TblProbeNext,cx

		mov	ax,cx
		sub	ax,TblWrNext
		js	TblWrLater

		add	cx,182*20		; limit write to once in 200 s
		mov	TblWrNext,cx

		mov	ax,TblSize
		mov	dx,TblActive
		cmp	dx,TblActLast
		ja	TblProbeWr

		cmp	ax,TblSizeLast
		jbe	TblWrLater
  TblProbeWr:
		mov	TblActLast,dx
		mov	TblSizeLast,ax
		call	TableWr
  TblWrLater:
		test	ArgFlags,TBL_PROBE
		jnz	TblDoProbe
  TblProbeRet:
		ret

  TblDoProbe:
		cmp	MyMask,0
		jne	TblProbeChkIntvl
		mov	dx,offset MsgNeedMask
		mov	al,'P'-'0'
		call	PrTerminate
  TblProbeChkIntvl:
if DEBUG
		cmp	TblProbIntvl,1
else
		cmp	TblProbIntvl,2
endif ; DEBUG
		jbe	TblProbMin
		dec	TblProbIntvl
  TblProbMin:

		mov	dx,TblIpProbe
		mov	ax,TblIpProbe+2
		cmp	ax,ArpTabIp2+2		; end of subnet numbers?
		jne	TblProbeMore
		cmp	dx,ArpTabIp1+2
		jne	TblProbeMore
		call	ProbeIpInit
  TblProbeMore:
		push	ds
		push	es
		call	BufAlloc
		mov	[bx].dTimOutMsg,0	; we don't require an answer
		mov	[bx].dTickTimeout,0	; don't wait
		call	SendArpReq		; send arp
		call	BufRelease
		pop	es
		pop	ds

		add	ah,1			; increment IP #
		adc	al,0
		adc	dh,0
		adc	dl,0
		mov	TblIpProbe,dx
		mov	TblIpProbe+2,ax

		mov	si,offset TblIpProbe
		mov	di,offset MsgTblDispl
		call	PutIpNum
		call	BlankUntil16
		ret
TblProbe	endp



;************************************************************************
;*		DoTable
;************************************************************************

DoTable 	proc	near
		assume	ds:nothing
		test	cs:GenFlags,TBL_READY
		jz	TableRetRel0
		cmp	cs:TblSize,0fff0h
		jb	$+5
  TableRetRel0:
		jmp	TableRetRel

		mov	ax,[bx].dPtrPhys
		call	ArpFindHw
		mov	[bx].dIdxHwDst,di

		mov	di,[bx].dPtrIp
		cmp	word ptr [di-2],0008h	; is this an IP pkt?
		jne	DoTabArp

		mov	dx,[di].iIpSrc
		mov	ax,[di].iIpSrc+2
		or	dx,dx
		jz	TableRetRel0		; ignore bootp requests
		mov	di,[bx].dPtrPhys
		add	di,cs:Hlen
		mov	bp,di
		add	di,cs:Hlen
		mov	[di],dx
		mov	[di+2],ax
		mov	cx,0200h		; fake an ARP reply
		mov	[bx].dIdxHwDst,ARPMYIDX
		jmp	short DoTabCommon
  DoTabArp:
		mov	cx,[di].iArpOp
		add	di,iArpMyHwAd
		mov	bp,di
		add	di,cs:Hlen
		mov	dx,[di]
		mov	ax,[di+2]
  DoTabCommon:
		mov	byte ptr [di+4],' '
		mov	ds:[bp-4],dx
		mov	ds:[bp-4+2],ax
		push	bx

		and	cs:GenFlags,not PROBE_REPLY
		cmp	cx,0200h		; ignore arp REPLIES from hosts
		jne	DoTabUpdate		; already known (probably a
		cmp	[bx].dIdxHwDst,ARPMYIDX ; proxy arp gateway)
		jne	DoTabUpdate

		or	cs:GenFlags,PROBE_REPLY
		push	ax
		mov	es,cs:SegHwIpTbl
		mov	si,bp
		mov	ax,11
		mov	bx,cs:TblSize
		call	FindIn16Table		; this Hw+IP addr already known?
		pop	ax
		je	DoTabUpdate		; -yes, lets update name

		push	ax
		mov	si,bp
		mov	ax,cs:Hlen
		mov	bx,cs:TblSize
		call	FindIn16Table		; this Hw addr already known?
		pop	ax
		jne	DoTabUpdate		; -no, must be a new one
		or	bx,bx			; does he use hw addr zero?
		jz	DoTabUpdate		; -yes, put him in the tables
		cmp	bx,cs:TblSize		; he believes HE is broadcast?
		jb	TableAnswered		; -no
  DoTabUpdate:					; put this addr in the tables
		call	FindHostInTbls
		jne	TableAdd

		cmp	byte ptr es:[bx].SlotPend,' '
		je	TableNew

		cmp	byte ptr es:[bx].SlotPend,'s'
		jb	TablePending
		dec	cs:TblActive
  TableNew:
		mov	byte ptr es:[bx].SlotPend,'p'
		inc	cs:TblActive
		jmp	short TableAsk
  TablePending:
		cmp	byte ptr es:[bx].SlotPend,'p'
		jb	TableAnswered

		inc	byte ptr es:[bx].SlotPend
  TableAnswered:
		push	cs
		pop	es
		pop	bx
		jmp	TableRetRel

  TableAdd:
		SHOW_EVENT	'b'
		mov	byte ptr es:[bx].SlotPend,'p'
		inc	cs:TblActive
		push	dx
		push	ax
		push	bx
		mov	si,bp
		add	si,cs:Hlen
		mov	di,cs:TblSize
		mov	es,cs:SegmNamTbl
		call	PutIpNum		; use IP # as name until
		call	BlankUntil16		;   we get nameserver reply
		add	cs:TblSize,16
		pop	bx
		pop	ax
		pop	dx
  TableAsk:
		SHOW_EVENT	'c'
		mov	cs:TblProbIntvl,9	; slow down probe to
		mov	es,cs:SegIpHwTbl	;   twice a second
		mov	cx,es:[bx].SlotNamPtr
		push	cx			; save name tbl idx

		push	cs
		pop	es

		xor	ch,ch
		mov	cl,dh
		xor	dh,dh
		push	dx
		push	cx
		mov	cl,ah
		xor	ah,ah
		push	ax
		push	cx

		mov	di,offset FileBuf
		mov	bl,4
		mov	cs:PutMinDigits,1
  TableNumLoop:
		mov	si,di
		inc	di
		pop	ax
		call	PutNum
		mov	es:[si],dl
		dec	bl
		jnz	TableNumLoop

		mov	si,offset InAdrArpa
		mov	cx,InAdrArpaLen
  TableNumL2:
		movs	byte ptr es:[FileBuf],cs:[InAdrArpa]
		loop	TableNumL2

		mov	dx,1234h		; tblbuild udp src port
		pop	ax			; NsId = name table index
		mov	si,offset FileBuf	; Ns question string

		call	NsResolve		; ask name for this #
		SHOW_EVENT	'd'
		pop	bx
  TableRetRel:
		call	BufRelease
  TableRet:
		ret
DoTable 	endp



;************************************************************************
;*		BlankUntil16 byte boundry
;************************************************************************

BlankUntil16	proc	near
		assume	ds:nothing
		mov	al,' '
  BlankMore:
		test	di,0fh
		jz	BlankRet
		stosb
		jmp	short BlankMore
  BlankRet:
		ret
BlankUntil16	endp



;************************************************************************
;*		NamePut from DS:SI to TblName[DI]
;************************************************************************

NamePut 	proc	near
		assume	ds:nothing
		mov	es,cs:SegmNamTbl
		mov	cx,16
  NamePutLoop:
		lodsb
		cmp	al,CR
		je	NamePutEnd
		stosb
		loop	NamePutLoop

		sub	di,16
		mov	es,cs:SegmNamTbl2
		mov	cx,16
  NamePutLoop2:
		lodsb
		cmp	al,CR
		je	NamePutEnd2
		stosb
		loop	NamePutLoop2

  NamePutEnd2:
		call	BlankUntil16
		jmp	short NamePutRet

  NamePutEnd:
		call	BlankUntil16

		mov	es,cs:SegmNamTbl2
		sub	di,16
		stosb
		jmp	short NamePutEnd2
  NamePutRet:
		push	cs
		pop	es
		ret
NamePut 	endp



;************************************************************************
;*		ThisIpFirst
;*	Input:		CS:DI = addr of length prepended IP list
;*			DS:BX = IP description buffer pointer
;*	Output: 	Moves source IP # to front of IP list
;************************************************************************

ThisIpFirst	proc	near
		assume	ds:nothing
		push	es
		push	cs
		pop	es
		mov	si,[bx].dPtrIp
		mov	dx,[si].iIpSrc
		mov	ax,[si].iIpSrc+2
		mov	cl,-1
		mov	ch,cs:[di] 		; list length
  ThisIpNext2:
		inc	di
		inc	di
  ThisIpNext4:
		inc	cl
		cmp	cl,ch			; more entries in list?
		jae	ThisIpRet

		xchg	ax,dx
		scasw				; first IP word match?
		xchg	ax,dx
		jne	ThisIpNext2

		scasw				; second IP word match?
		jne	ThisIpNext4

		dec	di
		lea	si,[di-4]
		std
		xor	ch,ch
		shl	cx,1
		jcxz	ThisIpL1e
  ThisIpL1:
		movs	word ptr es:[DefNS],cs:[DefNS]
		loop	ThisIpL1		; move entries downlist
  ThisIpL1e:
		cld
		inc	si
		mov	cs:[si],dx 		; insert src IP in front
		mov	cs:[si+2],ax
  ThisIpRet:
		pop	es
		ret
ThisIpFirst	endp


;************************************************************************
;*		DoName
;************************************************************************

DoName		proc	near
		assume	ds:nothing
		test	cs:GenFlags,TBL_READY
		jnz	NameInited

		ret
  NameInited:
		SHOW_EVENT	'e'
		push	ds
		pop	es
		lea	si,[di].uNsQuest
		mov	bp,[di].uNsId
		lea	di,[di].uNsNscount	; used for scratch
		mov	dx,si
		inc	dx

  BS		equ	'H'-040h
		call	NameDecode
		mov	word ptr [si],'  '
		mov	word ptr [si+2],BS+256*BS
		add	si,4

		push	dx
		push	si
		mov	si,dx
		call	GetIpNr
		pop	si
		pop	dx

		mov	di,[bx].dPtrUdp
		cmp	[di].uNsAncount,0100h
		je	NameHaveAns
		push	dx
		jmp	short NameNoAnswer
  NameHaveAns:
		mov	di,si
		call	NameDecode
		jnz	NameDcCompr
		mov	dx,di
		inc	dx
  NameDcCompr:
  TAB		equ	'I'-040h
		push	dx
		mov	word ptr [si],TAB+256*'N'
		mov	word ptr [si+2],'ma'
		mov	word ptr [si+4],'0e'
		mov	word ptr [si+6],'00'
		mov	word ptr [si+8],'=0'
		lea	di,[si+5]
		add	si,10
		mov	ax,bp
		mov	cl,4
		shr	ax,cl
		call	PutNumD4Fb
		mov	cs:PutMinDigits,2

		mov	di,si
		call	NameDecode
  NameNoAnswer:
		mov	word ptr [si],' '+256*CR
		mov	word ptr [si+2],LF+256*'$'

		mov	si,[bx].dPtrUdp
		mov	ax,[si].uNsNScount
		mov	dx,[si].uNsNscount+2
		xchg	ah,al
		xchg	dh,dl
		mov	[si].uNsNScount,dx
		mov	[si].uNsNScount+2,ax
		lea	si,[si].uNsNScount
		push	bx
		mov	bx,cs:TblSize
		mov	es,cs:SegIpHwTbl
		push	ax
		mov	ax,4
		call	FindIn16Table
		pop	ax
		mov	si,bx
		pop	bx
		je	NameFound
  NameNotFound:
		pop	dx
		call	DosPr$
		mov	al,'A'-'0'
		call	Terminate
  NameFound:					; find question to this answer
		mov	cx,si
  NameFindNxtHi:
		cmp	bp,es:[si].SlotNamPtr
		je	NameFoundThis
		add	si,16
		cmp	dx,es:[si]
		jne	NameFindLower
		cmp	ax,es:[si+2]
		je	NameFindNxtHi
  NameFindLower:
		mov	si,cx
  NameFindNxtLo:
		sub	si,16
		cmp	bp,es:[si].SlotNamPtr
		je	NameFoundThis
		cmp	dx,es:[si]
		jne	NameNotFound
		cmp	ax,es:[si+2]
		jne	NameNotFound
		jmp	short NameFindNxtLo
  NameFoundThis:
		mov	bp,[bx].dPtrUdp
		mov	dx,ds:[bp].uNsAncount
		mov	ax,ds:[bp].uNsOpwd
		and	ah,0fh
		cmp	ah,1			; format error?
		jne	NameFmtOK

		mov	al,'F'-'0'
		call	Terminate
  NameFmtOK:
		mov	byte ptr es:[si].SlotPend,'t' ; try again next time

		cmp	ah,2			; temporary server problem?
		je	NameSkipUpd

		test	al,4			; authorititive answer?
		jz	NameTryLater

		mov	byte ptr es:[si].SlotPend,'0' ; we ask no more about this #
  NameTryLater:
		or	ah,ah			; any other error?
		jnz	NameSkipUpd

		cmp	dx,0100h		; any answer?
		jne	NameSkipUpd

		mov	byte ptr es:[si].SlotPend,'N' ; we ask no more about this #
		test	al,4			; authorititive answer?
		jz	NameNotAuth

		mov	byte ptr es:[si].SlotPend,'A' ; we ask no more about this #
  NameNotAuth:
		mov	si,es:[si].SlotNamPtr
		xchg	si,di
		inc	si
		call	NamePut			; put real name into nametable
		SHOW_EVENT	'f'
  NameSkipUpd:
		push	cs
		pop	es
		pop	dx
		call	DosPr$

		or	cs:Events,GOT_NSREPLY
		mov	di,offset DefNsNum
		call	ThisIpFirst		; stick to this nameserver
  NameRet:
		ret
DoName		endp



;************************************************************************
;*		TabMarkGw
;************************************************************************

TabMarkGw	proc	near
		SHOW_EVENT	'g'
		assume	ds:code_s
		mov	bx,TblSize
		mov	ds,SegIpHwTbl
		assume	ds:nothing
  TabMarkLoop:
		mov	si,bx
		mov	dx,[si].SlotIp
		mov	ax,[si].SlotIp+2
		mov	cx,cs:DefGwyNum
		mov	si,offset DefGwys
		jcxz	TabGwyDone
  TabGwyLoop:
		cmp	ax,cs:[si].SlotIp+2
		jne	TabGwyNext
		cmp	dx,cs:[si].SlotIp
		jne	TabGwyNext
		mov	byte ptr [bx].SlotDupl,'+'
		jmp	short TabGwyDone
  TabGwyNext:
		add	si,4
		loop	TabGwyLoop
  TabGwyDone:
		sub	bx,16
		jns	TabMarkLoop

		mov	bx,cs:TblSize
  TabDupLoop:
		mov	si,bx
  TabMarkHwLoop:
		sub	si,16
		js	TabDupNext

		mov	ax,[si].SlotHw+4
		cmp	ax,[bx].SlotHw+4
		jne	TabMarkHwLoop
		mov	ax,[si].SlotHw+2
		cmp	ax,[bx].SlotHw+2
		jne	TabMarkHwLoop
		mov	ax,[si].SlotHw
		cmp	ax,[bx].SlotHw
		jne	TabMarkHwLoop

		cmp	byte ptr [si].SlotDupl,'+'
		je	TabMarkHwDup

		mov	byte ptr [si].SlotDupl,'>'
		cmp	byte ptr [bx].SlotDupl,'>'
		je	TabMarkHwDup

		cmp	byte ptr [bx].SlotDupl,'+'
		je	TabMarkHwLoop

		mov	byte ptr [bx].SlotDupl,'='
		jmp	short TabMarkHwLoop

  TabMarkHwDup:
		cmp	byte ptr [bx].SlotDupl,'+'
		je	TabMarkHwLoop

		mov	byte ptr [bx].SlotDupl,'>'
		jmp	short TabMarkHwLoop
  TabDupNext:
		sub	bx,16
		jns	TabDupLoop

		push	cs
		pop	ds
		ret
TabMarkGw	endp


;************************************************************************
;*		TabOpen
;************************************************************************

TabOpen 	proc	near
		assume	ds:code_s
		mov	ax,3d02h
		int	21h
		mov	Handle,ax
		jnc	TabOpenRet
		mov	al,'B'-'0'
		call	Terminate
  TabOpenRet:
		ret
TabOpen 	endp



;************************************************************************
;*		TabPutHw
;************************************************************************

TabPutHw	proc	near
		assume	ds:nothing
		mov	ds,cs:SegIpHwTbl
		lea	si,[bx].SlotHw
		call	PutHwNum

		mov	ds,cs:SegIpHwTbl
		cmp	byte ptr [bx].SlotDupl,'>'
		clc
		jne	TabPutHwRet

		stc

  TabPutHwRet:
		ret
TabPutHw	endp



;************************************************************************
;*		TabPutName
;************************************************************************

TabPutName	proc	near
		assume	ds:nothing
		push	bx
		mov	ds,cs:SegIpHwTbl
		mov	bx,[bx].SlotNamPtr
		mov	cx,8
		mov	ds,cs:SegmNamTbl
		mov	si,bx
		mov	dl,[si]
		rep	movsw
		mov	cx,8
		mov	ds,cs:SegmNamTbl2
		mov	si,bx
		rep	movsw
		mov	ax,'# '
		stosw

		pop	bx
		push	bx
		mov	ds,cs:SegIpHwTbl
		mov	si,bx
		mov	ah,[si].SlotPend
		cmp	dl,'0'
		jb	TabPutKnown
		cmp	dl,'9'
		ja	TabPutKnown
		mov	al,'-'
  TabPutKnown:
		mov	dx,[si].SlotIp
		mov	cx,[si].SlotIp+2
		cmp	dx,[si].SlotIp+16
		jne	TabPutNeN
		cmp	cx,[si].SlotIp+16+2
		jne	TabPutNeN
		mov	al,'='
  TabPutNeN:
		cmp	dx,[si].SlotIp-16
		jne	TabPutNeP
		cmp	cx,[si].SlotIp-16+2
		jne	TabPutNeP
		mov	al,'<'
  TabPutNeP:
		stosw
		mov	al,[bx].SlotDupl
		stosb
		pop	bx
		ret
TabPutName	endp



;************************************************************************
;*		TabPutIp
;************************************************************************

TabPutIp	proc	near
		assume	ds:nothing
		mov	ds,cs:SegIpHwTbl
		mov	si,bx
		call	PutIpNum
		ret
TabPutIp	endp



;************************************************************************
;*		TabWrLine
;************************************************************************

TabWrLine	proc	near
		push	cs
		pop	ds
		assume	ds:code_s
		push	bx
		mov	cx,di
		mov	dx,offset FileBuf
		sub	cx,dx
		mov	bx,Handle
		mov	ah,40h
		int	21h
		jnc	TabWrOK
  TabWrErr:
		mov	al,'W'-'0'
		call	Terminate
  TabWrOK:
		pop	bx
		ret
TabWrLine	endp



;************************************************************************
;*		TabClose
;************************************************************************

TabClose	proc	near
		assume	ds:code_s
		mov	byte ptr FileBuf,'Z'-40h
		mov	dx,offset FileBuf
		mov	cx,1
		mov	bx,Handle
		mov	ah,40h
		int	21h
		jc	TabWrErr

		mov	bx,Handle
		mov	ah,3eh
		int	21h
		jnc	TabHwClOK

		mov	al,'C'-'0'
		call	Terminate
  TabHwClOK:
		ret
TabClose	endp



;************************************************************************
;*		TabWrSeen
;************************************************************************

TabWrSeen	proc	near
		assume	ds:nothing
		mov	ax,[bx].SlotSeen
		push	cs
		pop	ds
		assume	ds:code_s
		mov	PutMinDigits,9
		call	PutNumFb
		mov	PutMinDigits,1
		ret
TabWrSeen	endp



;************************************************************************
;*		TableWr
;************************************************************************

TableWr 	proc	near
		assume	ds:code_s
		cmp	TblSize,16
		ja	TableExist
		ret

  TableExist:
		push	bx

		call	TabMarkGw

		mov	dx,offset NameIpTbl
		call	TabOpen
		mov	bx,16
  TabIpNext:
		mov	di,offset FileBuf

		call	TabPutIp
		assume	ds:nothing

		call	BlankUntil16

		call	TabPutName

		push	cs:ArgFlags
		and	cs:ArgFlags, not LANW_TABLE
		call	TabPutHw
		pop	cs:ArgFlags

		call	TabWrSeen

		mov	ax,CR+256*LF
		stosw

		call	TabWrLine
		assume	ds:code_s

		add	bx,16
		cmp	bx,TblSize
		jb	TabIpNext

		call	TabClose

		mov	dx,offset NameHwTbl
		call	TabOpen
		mov	bx,16
  TabHwNext:
		mov	di,offset FileBuf
		call	TabPutHw
		assume	ds:nothing
		pushf

		mov	al,' '
		stosb
		call	TabPutName

		call	TabPutIp

		call	BlankUntil16
		sub	di,10

		call	TabWrSeen

		mov	ax,CR+256*LF
		stosw

		popf

		call	TabWrLine
		assume	ds:code_s
  TabPutHwSkip:
		add	bx,16
		cmp	bx,TblSize
		jb	TabHwNext

		mov	bx,16
		mov	es,SegIpHwTbl
  TabPutRestore:
		mov	es:[bx].SlotDupl,' '
		add	bx,16
		cmp	bx,TblSize
		jb	TabPutRestore
		push	cs
		pop	es

		call	TabClose

		pop	bx

		mov	di,offset MsgTblSize+6
		mov	ax,TblSize
		mov	cl,4
		shr	ax,cl
		dec	ax
		call	PutNumD4Fb
		mov	di,offset MsgTblAct
		mov	ax,TblActive
		call	PutNum
		mov	dx,offset MsgTblSize
		call	DosPr$
		ret
TableWr 	endp

;========================================================================

