#include <i86.h>
#include <stdio.h>
#include <string.h>

#include "defines.hpp"

#include "dpmi.hpp"
#include "vesa.hpp"

extern "C" long  VESA_MinX = 0; 
extern "C" long  VESA_MinY = 0;
extern "C" long  VESA_MaxX = 0;
extern "C" long  VESA_MaxY = 0;
extern "C" DWORD VESA_BpL = 0;
extern "C" char  VESA_BpP = 0;
extern "C" DWORD VESA_OFSTable [4096] = {0};
extern "C" WORD  VESA_Selector = 0;
extern "C" DWORD VESA_ScreenSize_Byte = 0;
extern "C" void* VESA_ScreenPtr = 0;
extern "C" WORD  VESA_SecondScreen_Sel = 0;
extern "C" DWORD VESA_SecondScreen_StartY = 0;
extern "C" DWORD VESA_XResolution = 0;
extern "C" DWORD VESA_YResolution = 0;
extern "C" DWORD VESA_TableOfModes = 0;

#include "vesaproc.cpp"

struct VESA_INFO {
    char VESASignature [4];
    WORD VESAVersion;
    DWORD OEMStringPtr;
    DWORD Capabilities;
    DWORD VideoModePtr;
    WORD TotalMemory;
    char Reserved [242];
};

struct VESA_MODEINFO {
    unsigned short ModeAttributes;
    char WinAAttributes;
    char WinBAttributes;
    short WinGranularity;
    short WinSize;
    short WinASegment;
    short WinBSegment;
    void* WinFuncPtr;
    unsigned short BytesPerScanLine;
    short XResolution;
    short YResolution;
    char XCharSize;
    char YCharSize;
    char NumberOfPlanes;
    char BitsPerPixel;
    char NumberOfBanks;
    char MemoryModel;
    char BankSize;
    char NumberOfImagePages;
    char Reserved;
    char RedMaskSize;
    char RedFieldPosition;
    char GreenMaskSize;
    char GreenFieldPosition;
    char BlueMaskSize;
    char BlueFieldPosition;
    char RsvdMaskSize;
    char RsvdFieldPosition;
    char DirectColorModeInfo;
    void* PhysBasePtr;
    long OffScreenMemOffset;
    short OffScreenMemSize;
    char Nothing [206];
};
    
VESA_MODEINFO far* VESAModeInfo ;
WORD VESAModeInfo_Seg;
VESA_INFO far* VESAInfo;
WORD VESAInfo_Seg;

WORD VESA_SetMode ( WORD Mode ) {
    union REGS Regs;
    struct SREGS SegRegs;
    static struct DPMI_RMINTREGS IntRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    memset ( &IntRegs , 0 , sizeof ( IntRegs ) );
    IntRegs.EAX = 0x00004F02;
    IntRegs.EBX = Mode;
    IntRegs.SS = 0;
    IntRegs.SP = 0;
    Regs.w.ax = 0x0300;
    Regs.h.bl = 0x10;
    Regs.h.bh = 0;
    Regs.w.cx = 0;
    SegRegs.es = FP_SEG ( &IntRegs );
    Regs.x.edi = FP_OFF ( &IntRegs );
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    return WORD( IntRegs.EAX );
};

WORD VESA_SetScanLineLength ( WORD L ) {
    union REGS Regs;
    struct SREGS SegRegs;
    static struct DPMI_RMINTREGS IntRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    memset ( &IntRegs , 0 , sizeof ( IntRegs ) );
    IntRegs.EAX = 0x00004F06;
    IntRegs.EBX = 0;
    IntRegs.ECX = L;
    IntRegs.SS = 0;
    IntRegs.SP = 0;
    Regs.w.ax = 0x0300;
    Regs.h.bl = 0x10;
    Regs.h.bh = 0;
    Regs.w.cx = 0;
    SegRegs.es = FP_SEG ( &IntRegs );
    Regs.x.edi = FP_OFF ( &IntRegs );
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    return WORD( IntRegs.EAX );
};

/*
DWORD SetDispStart;
     
WORD GetVESAProcs() {
    union REGS Regs;
    struct SREGS SegRegs;
    static struct DPMI_RMINTREGS IntRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    memset ( &IntRegs , 0 , sizeof ( IntRegs ) );
    IntRegs.EAX = 0x00004F0A;
    IntRegs.EBX = 0;
    IntRegs.SS = 0;
    IntRegs.SP = 0;
    Regs.w.ax = 0x0300;
    Regs.h.bl = 0x10;
    Regs.h.bh = 0;
    Regs.w.cx = 0;
    SegRegs.es = FP_SEG ( &IntRegs );
    Regs.x.edi = FP_OFF ( &IntRegs );
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    DWORD TableStart = (IntRegs.ES << 4) + WORD( IntRegs.EDI );
    SetDispStart = TableStart + *(WORD*)(TableStart+2);
    return WORD( IntRegs.EAX );
};
*/

void VESA_AllocateModeInfo( VESA_MODEINFO far* &VMI, WORD &VMI_SEG ) {
    union REGS Regs;
    struct SREGS SegRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    Regs.w.ax = 0x0100;
    Regs.w.bx = 0x0010;
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    WORD Segment = Regs.w.ax;
    WORD Selector = Regs.w.dx;
    VMI = Selector:>(VESA_MODEINFO*) 0;
    VMI_SEG = Segment;
};
     
WORD VESA_GetModeInfo ( WORD Mode , WORD VMI_SEG ) {
    union REGS Regs;
    struct SREGS SegRegs;
    static struct DPMI_RMINTREGS IntRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    memset ( &IntRegs , 0 , sizeof ( IntRegs ) );
    IntRegs.EAX = 0x00004F01;
    IntRegs.ECX = Mode;
    IntRegs.ES = VMI_SEG;
    IntRegs.EDI = 0;
    IntRegs.SS = 0;
    IntRegs.SP = 0;
    Regs.w.ax = 0x0300;
    Regs.h.bl = 0x10;
    Regs.h.bh = 0;
    Regs.w.cx = 0;
    SegRegs.es = FP_SEG ( &IntRegs );
    Regs.x.edi = FP_OFF ( &IntRegs );
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    return WORD( IntRegs.EAX );    
};

void VESA_AllocateInfo( VESA_INFO far* &VI, WORD &VI_SEG ) {
    union REGS Regs;
    struct SREGS SegRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    Regs.w.ax = 0x0100;
    Regs.w.bx = 0x0010;
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    WORD Segment = Regs.w.ax;
    WORD Selector = Regs.w.dx;
    VI = Selector:>(VESA_INFO*) 0;
    VI_SEG = Segment;
};

WORD VESA_GetInfo ( WORD VI_SEG ) {
    union REGS Regs;
    struct SREGS SegRegs;
    static struct DPMI_RMINTREGS IntRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    memset ( &IntRegs , 0 , sizeof ( IntRegs ) );
    IntRegs.EAX = 0x00004F00;
    IntRegs.ES = VI_SEG;
    IntRegs.EDI = 0;
    IntRegs.SS = 0;
    IntRegs.SP = 0;
    Regs.w.ax = 0x0300;
    Regs.h.bl = 0x10;
    Regs.h.bh = 0;
    Regs.w.cx = 0;
    SegRegs.es = FP_SEG ( &IntRegs );
    Regs.x.edi = FP_OFF ( &IntRegs );
    int386x ( 0x31 , &Regs , &Regs , &SegRegs );
    return WORD( IntRegs.EAX );    
};

WORD VESA_CheckIfSupported ( WORD Mode , DWORD Table ) {
    WORD* Modes;
    Table = (DWORD)( Table & 0xffff ) +
            (DWORD)( ( Table >> 16 ) << 4 );
    for ( Modes = (WORD*)Table;
          ( *Modes != Mode ) && ( *Modes != WORD( -1 ) );
          Modes += 1 );
    return *Modes;
};

void VESA_PrintModeList8B() {
    WORD *Modes = (WORD*)VESA_TableOfModes;
    for ( ; *Modes != WORD(-1); Modes++ ) {
        VESA_GetModeInfo( *Modes, VESAModeInfo_Seg );
        if ( (*VESAModeInfo).BitsPerPixel == 8 )
            printf( "Mode %x : %ix%i\n", *Modes, (*VESAModeInfo).XResolution,
                                                 (*VESAModeInfo).YResolution );
    };
};

WORD VESA_InitMode ( WORD Mode ) {
    WORD Status;

    WORD Supported = VESA_CheckIfSupported( Mode, (*VESAInfo).VideoModePtr );
    if ( Supported == WORD(-1) ) {
        printf ( "\n" );
        printf ( "ERROR : VESA-Mode not supported !\n" );
        return 1; };

    Status = VESA_GetModeInfo( Mode , VESAModeInfo_Seg );
    if ( Status >= 0x0100 ) {
        printf ( "\n" );
        printf ( "ERROR : Couldn't get VESA-Modeinfo !\n");
        return 1; };

    if ( (*VESAModeInfo).ModeAttributes & 0x80 == 0 ) {
        printf ( "\n" );
        printf ( "ERROR : VESA-Mode doesn't support Flat Memory !\n" );
        return 1; };

    VESA_XResolution = (*VESAModeInfo).XResolution;
    VESA_YResolution = (*VESAModeInfo).YResolution;
    VESA_BpL = (*VESAModeInfo).BytesPerScanLine;
    VESA_BpP = (*VESAModeInfo).BitsPerPixel;
    VESA_ScreenSize_Byte = VESA_BpL * (*VESAModeInfo).YResolution;
    VESA_SetClipArea( 0, 0, (*VESAModeInfo).XResolution - 1, (*VESAModeInfo).YResolution - 1 );
    for ( int i=0 ; i < 4096 ; i++ ) {
        VESA_OFSTable[i] = i*VESA_BpL;
    };
    VESA_SecondScreen_StartY = (*VESAModeInfo).YResolution;

    Status = VESA_SetMode ( WORD( Mode + 0x4000 ) );

    if ( Status >= 0x0100 ) {
        VESA_SetMode ( 3 );
        printf ( "\n" );
        printf ( "ERROR : Couldn't initialize VESA-Mode ...\n" );
        return 1; };

    // VESA_GetProcs();
        
    VESA_ScreenPtr = DPMI_FreeAccess ( (*VESAModeInfo).PhysBasePtr , 0x800000 );
    VESA_Selector = DPMI_GetSelector ( VESA_ScreenPtr );
    VESA_SecondScreen_Sel = DPMI_GetSelector ((void*)((DWORD)VESA_ScreenPtr + VESA_ScreenSize_Byte));

    // VESA_SetScanLineLength( WORD(VESA_XResolution) );

    return 0;
};

WORD VESA_Boot() {
    VESA_AllocateModeInfo( VESAModeInfo, VESAModeInfo_Seg );
    VESA_AllocateInfo( VESAInfo, VESAInfo_Seg );
    VESA_GetCodeAlias();
    
    WORD Status = VESA_GetInfo( VESAInfo_Seg );
    if ( Status >= 0x0100 ) {
        printf ( "\n" );
        printf ( "ERROR : Couldn't get VBE-Info !\n" );
        return 1; };
    if ( (*VESAInfo).VESAVersion >> 8 < 2 ) {
        printf ( "\n" );
        printf ( "ERROR : VBE Version 2.0 or higher required !\n" );
        return 1; };
 
    VESA_TableOfModes = DWORD((*VESAInfo).VideoModePtr);
    VESA_TableOfModes = (VESA_TableOfModes & 0xffff) + ((VESA_TableOfModes >> 16) << 4);

    return 0;
};

void VESA_Exit() {
    DPMI_CloseAccess( VESA_ScreenPtr );
    DPMI_FreeSelector( VESA_Selector );
    DPMI_FreeSelector( VESA_SecondScreen_Sel );
};

void VESA_SetTextMode() {
    VESA_SetMode( 3 );
};

