***************************************************************************
*
* Procedure file: 3DBOX.PRG
*         System: 3DBox
*        Version: 1.2
*         Author: Bill Anderson
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* 3DBOX - 3D Box Generator.
*
* Description:
* This program is used to draw a 3-D box.
*
*                  * * *  PARAMETER MEMORY VARIABLES  * * *
*
*            m_boxrow   = holds the beginning row of the box.
*            m_boxcol   = holds the beginning column of the box.
*            m_boxhgt   = holds the height of the drawn box.
*            m_boxwdth  = holds the width of the drawn box.
*            m_boxpenw  = holds the pen width of the bevel.
*            m_sunr     = hold the red color intensity of
*                         the sun color.
*            m_sung     = hold the green color intensity of
*                         the sun color.
*            m_sunb     = hold the blue color intensity of
*                         the sun color.
*            m_shader   = hold the red color intensity of
*                         the shade color.
*            m_shadeg   = hold the green color intensity of
*                         the shade color.
*            m_shadeb   = hold the blue color intensity of
*                         the shade color.
*            m_facer    = hold the red color intensity of
*                         the face color.
*            m_faceg    = hold the green color intensity of
*                         the face color.
*            m_faceb    = hold the blue color intensity of
*                         the face color.
*            m_outliner = hold the red color intensity of
*                         the outline color.
*            m_outlineg = hold the green color intensity of
*                         the outline color.
*            m_outlineb = hold the blue color intensity of
*                         the outline color.
*            m_pattern  = holds the pattern of the face of the
*                         3-D box.
*            m_pentype  = holds the pen type used for 
*                         the outline box.
*
*                  * * *  DECLARED MEMORY VARIABLES  * * *
*
*            m_setdec   = holds the previous SET DECIMAL setting
*            m_curfont  = holds the font type used to calculate
*                         the pixel lengths.
*            m_cursize  = holds the font size used to calculate
*                         the pixel lengths.
*            m_curstyle = holds the font style used to calculate
*                         the pixel lengths.
*            m_hclength = holds the horizontal pixel to 
*                         character ratio.
*            m_vclength = holds the vertical pixel to 
*                         character ratio.
*            m_currow   = holds the passed row.
*            m_curcol   = holds the passed column.
*            m_looppen  = holds the interim pen value for the boxes
*                         and triangles.
*            m_prevpen  = holds the previous pen value when
*                         going through the drawing loop.
*            m_counter  = a counter.
*            mcounter   = another counter.
*                         
* 
************************************************************************
* Example:
*
* DO 3DBOX.PRG WITH 6, 10, 10, 5, 4, 255, 255, 255, ;
* 128, 128, 128, 192, 192, 192, 0, 0, 0, 1, -1
*
************************************************************************
*

PARAMETERS m_boxrow, m_boxcol, m_boxhgt, m_boxwdth, m_boxpenw, ;
m_sunr, m_sung, m_sunb, m_shader, m_shadeg, m_shadeb, ;
m_facer, m_faceg, m_faceb, m_outliner, m_outlineg, ;
m_outlineb, m_pattern, m_pentype

PRIVATE m_boxrow, m_boxcol, m_boxhgt, m_boxwdth, m_boxpenw, ;
m_sunr, m_sung, m_sunb, m_shader, m_shadeg, m_shadeb, ;
m_facer, m_faceg, m_faceb, m_outliner, m_outlineg, ;
m_outlineb, m_pattern, m_pentype, m_setdec, m_curfont, ;
m_cursize, m_curstyle, m_hclength, m_vclength, m_currow, ;
m_curcol, m_looppen, m_prevpen, m_counter

** Windows platform test
IF .NOT._WINDOWS
  WAIT 'This program requires FoxPro for Windows' WINDOW NOWAIT
  RETURN
ENDIF
** End Windows platform test

** Negative row test
IF m_boxrow < 0

  WAIT WINDOW [Negative row provided for this box.] NOWAIT
  RETURN .f.

ENDIF m_boxrow < 0
** End negative row test

** Negative column test
IF m_boxcol < 0

  WAIT WINDOW [Negative column provided for this box.] NOWAIT
  RETURN .f.

ENDIF m_boxcol < 0
** End negative column test

** Bad width test
IF m_boxwdth <= 0

  WAIT WINDOW [Invalid width provided for this box.] NOWAIT
  RETURN .f.

ENDIF m_boxwdth <= 0
** End bad width test

** Bad height test
IF m_boxwdth <= 0

  WAIT WINDOW [Invalid height provided for this box.] NOWAIT
  RETURN .f.

ENDIF m_boxwdth <= 0
** End bad height test

** Empty button face pattern test
IF TYPE([m_pattern]) # [N] OR EMPTY(m_pattern)

  m_pattern = 1

ENDIF TYPE([m_pattern]) # [N] OR EMPTY(m_pattern)
** End empty button face pattern test

** Empty outline pen type test
IF TYPE([m_pentype]) # [N] OR EMPTY(m_pentype)

  m_pentype = -1

ENDIF EMPTY([m_pentype])
** End empty outline pen type test

** Width too long test
IF m_boxcol + m_boxwdth >= WCOLS()

  WAIT WINDOW [Box width too long for window.] NOWAIT
  RETURN .f.

ENDIF m_boxcol + m_boxwdth >= WCOLS()
** End width too long test

** Height too big test
IF m_boxrow + m_boxhgt >= WROWS()

  WAIT WINDOW [Box height too big for window.] NOWAIT
  RETURN .f.

ENDIF m_boxrow + m_boxhgt >= WROWS()
** End height too big test

** Pen width type test
IF TYPE([m_boxpenw]) # [N]

  m_boxpenw = 0

ENDIF TYPE([m_boxpenw]) # [N]
** End pen width type test

** Pen width value test
IF BETWEEN(m_boxpenw, -2, 2)

  m_boxpenw = ROUND(m_boxpenw, 0)

ENDIF BETWEEN(m_boxpenw, -2, 2)
** End pen width value test

** Memory variable type test
IF TYPE([m_sunr]) # [N]

  m_sunr = 255

ENDIF TYPE([m_sunr]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_sung]) # [N]

  m_sung = 255

ENDIF TYPE([m_sung]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_sunb]) # [N]

  m_sunb = 255

ENDIF TYPE([m_sunb]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_shader]) # [N]

  m_shader = 128

ENDIF TYPE([m_shader]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_shadeg]) # [N]

  m_shadeg = 128

ENDIF TYPE([m_shadeg]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_shadeb]) # [N]

  m_shadeb = 128

ENDIF TYPE([m_shadeb]) # [N]
** End memory variable type test

** In-laid box test
IF m_boxpenw < 0

  m_tempr = m_sunr
  m_tempg = m_sung
  m_tempb = m_sunb
  m_sunr = m_shader
  m_sung = m_shadeg
  m_sunb = m_shadeb
  m_shader = m_tempr
  m_shadeg = m_tempg
  m_shadeb = m_tempb
  m_boxpenw = -m_boxpenw
  
ENDIF m_boxpenw < 0
** End in-laid box test

** Memory variable type test
IF TYPE([m_facer]) # [N]

  m_facer = 192

ENDIF TYPE([m_facer]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_faceg]) # [N]

  m_faceg = 192

ENDIF TYPE([m_faceg]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_faceb]) # [N]

  m_faceb = 192

ENDIF TYPE([m_faceb]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_outliner]) # [N]

  m_outliner = 192

ENDIF TYPE([m_outliner]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_outlineg]) # [N]

  m_outlineg = 192

ENDIF TYPE([m_outlineg]) # [N]
** End memory variable type test

** Memory variable type test
IF TYPE([m_outlineb]) # [N]

  m_outlineb = 192

ENDIF TYPE([m_outlineb]) # [N]
** End memory variable type test

m_setdec = SET([DECIMALS])
SET DECIMALS TO 15
m_woutput = WOUTPUT()
m_curfont = WFONT(1, m_woutput)       && holds the current font
m_cursize = WFONT(2, m_woutput)       && holds the current size
m_curstyle = WFONT(3, m_woutput)      && holds the current style
m_hclength = FONTMETRIC(6, m_curfont, m_cursize, m_curstyle)
m_vclength = FONTMETRIC(1, m_curfont, m_cursize, m_curstyle) + ;
FONTMETRIC(5, m_curfont, m_cursize, m_curstyle)

** Pen thickness test
IF m_hclength * m_boxwdth <= m_boxpenw * 2

  WAIT WINDOW [Pen width along horizontal axis too thick.] NOWAIT
  RETURN .f.

ENDIF m_hclength * m_boxwdth <= m_boxpenw * 2
** End pen thickness test

** Pen thickness test
IF m_vclength * m_boxhgt <= m_boxpenw * 2

  WAIT WINDOW [Pen width along vertical axis too thick.] NOWAIT
  RETURN .f.

ENDIF m_hclength * m_boxwdth <= m_boxpenw * 2
** End pen thickness test

m_currow = m_boxrow
m_curcol = m_boxcol
m_looppen = m_boxpenw

** Box drawing loop
FOR m_counter = 1 TO CEILING(m_boxpenw / 6)

   m_looppen = IIF(m_looppen < 7, m_looppen, 6)
   
   ** First time through test
   IF m_counter = 1
   
     m_prevpen = m_looppen
     
   ENDIF m_counter = 1
   ** End first time through test
   
   DO BOXDRAW

   ** Row adjustment test
   IF m_counter < CEILING(m_boxpenw / 6)
   
     m_boxrow = m_boxrow + (m_looppen / m_vclength)
     m_boxcol = m_boxcol + (m_looppen / m_hclength)
     m_prevpen = m_looppen
     m_looppen = m_boxpenw - (6 * m_counter)
     
   ENDIF m_counter < CEILING(m_boxpenw / 6)
   ** End row adjustment test

ENDFOR m_counter = 1 TO CEILING(m_boxpenw / 6)
** End box drawing loop

** Button face
@ m_currow + (m_boxpenw / m_vclength), ;
m_curcol + (m_boxpenw / m_hclength) TO ;
(m_currow + m_boxhgt) - (m_boxpenw / m_vclength), ;
(m_curcol + m_boxwdth) - (m_boxpenw / m_hclength) ;  
PATTERN m_pattern COLOR ;
RGB(m_facer, m_faceg, m_faceb, m_facer, m_faceg, m_faceb)

** Outline box
@ m_currow, m_curcol TO m_currow + m_boxhgt, m_curcol + m_boxwdth ;
PATTERN 0 PEN 0, m_pentype STYLE [1] ;
COLOR RGB(m_outliner, m_outlineg, m_outlineb, ;
m_outliner, m_outlineg, m_outlineb)

SET DECIMALS TO &m_setdec

RETURN 

*****************
PROCEDURE BOXDRAW
*****************

** Top line
@ m_boxrow, m_boxcol TO ;
m_boxrow, m_boxcol + ;
(m_boxwdth - (((((2 * m_counter) - 1) * ;
m_prevpen) - (m_prevpen - m_looppen)) / m_hclength)) ;
PATTERN 0 PEN m_looppen STYLE [0] ;
COLOR RGB(m_sunr, m_sung, m_sunb, m_sunr, m_sung, m_sunb)

** Upper right triangles
DO TRIANGLES WITH m_boxrow, m_boxcol + ;
(m_boxwdth - (((((2 * m_counter) - 1) * ;
m_prevpen) - (m_prevpen - m_looppen)) / m_hclength))

** Left line
@ m_boxrow + (m_looppen / m_vclength), m_boxcol TO ;
m_boxrow + (m_boxhgt - (((((2 * m_counter) - 1) * ;
m_prevpen) - (m_prevpen - m_looppen)) / m_vclength)), m_boxcol ;
PATTERN 0 PEN m_looppen STYLE [0] ;
COLOR RGB(m_sunr, m_sung, m_sunb, m_sunr, m_sung, m_sunb) 

** Right line
@ m_boxrow + (m_looppen / m_vclength), ;
m_boxcol + (m_boxwdth - (((((2 * m_counter) - 1) * ;
m_prevpen) - (m_prevpen - m_looppen)) / m_hclength)) TO ;
m_boxrow + m_boxhgt - ;
((((m_counter - 1) * 2) * m_prevpen) / m_vclength), ;
m_boxcol + (m_boxwdth - (((((2 * m_counter) - 1) * ;
m_prevpen) - (m_prevpen - m_looppen)) / m_hclength)) ;
PATTERN 0 PEN m_looppen STYLE [0] ;
COLOR RGB(m_shader, m_shadeg, m_shadeb, m_shader, m_shadeg, m_shadeb)

** Lower left triangles
DO TRIANGLES WITH m_boxrow + ;
(m_boxhgt - (((((2 * m_counter) - 1) * ;
m_prevpen) - (m_prevpen - m_looppen)) / m_vclength)), m_boxcol

** Bottom line
@ m_boxrow + (m_boxhgt - (((((2 * m_counter) - 1) * ;
m_prevpen) - (m_prevpen - m_looppen)) / m_vclength)), ;
m_boxcol + (m_looppen / m_hclength) TO ;
m_boxrow + (m_boxhgt - (((((2 * m_counter) - 1) * ;
m_prevpen) - (m_prevpen - m_looppen)) / m_vclength)), ;
m_boxcol + (m_boxwdth - (((((2 * m_counter) - 1) * ;
m_prevpen) - (m_prevpen - m_looppen)) / m_hclength)) ;
PATTERN 0 PEN m_looppen STYLE [0] ;
COLOR RGB(m_shader, m_shadeg, m_shadeb, m_shader, m_shadeg, m_shadeb)

RETURN

*******************
PROCEDURE TRIANGLES
*******************

PARAMETER m_row, m_col

PRIVATE mcounter

** Line drawing loop
FOR mcounter = 1 TO m_looppen

  @ m_row + ((mcounter - 1) / m_vclength), m_col TO ;
  m_row + ((mcounter - 1) / m_vclength), ;
  m_col + ((m_looppen - mcounter) / m_hclength) ;
  PATTERN 0 PEN 1 STYLE [0] ;
  COLOR RGB(m_sunr, m_sung, m_sunb)
  @ m_row + ((mcounter - 1) / m_vclength), ;
  m_col + ((m_looppen - mcounter) / m_hclength) TO ;
  m_row + ((mcounter - 1) / m_vclength), ;
  m_col + (m_looppen / m_hclength) ;
  PATTERN 0 PEN 1 STYLE [0] ;
  COLOR RGB(m_shader, m_shadeg, m_shadeb)
  
ENDFOR mcounter = 1 TO m_looppen
** End line drawing loop

RETURN

* EOF: 3DBOX.PRG