***************************************************************************
*
* Procedure file: 3D.PRG
*         System: GenScrnX
*        Version: 1.1
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* 3D - 3D driver.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* 3D boxes with beveling by calling 3DBOX.PRG
* 3D boxes.
* 3D lines.
* 3D text.
* 3D SAYs.
* 3D GETs.
* 3D EDITs.
* 3D check boxes.
* 3D lists.
* 3D popups.
* 3D spinners.
* 3D pictures.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* All function calls made from this program are contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PRIVATE m.c_3d,m.c_no3d,m.c_get3d,m.c_say3d,m.c_pict3d,m.c_box3d,m.c_inset3d
PRIVATE m.c_raised3d,m.c_all3d,m.c_text3d,m.c_box,m.c_color,m.c_rgb,m.c_ins
PRIVATE m.cfontstylm,m.cfontstyl,m.cbevel,m.shadered,m.shadegreen,m.shadeblue
PRIVATE m.vfontratio,m.hfontratio,m.vfactor,m.hfactor,m.wtfactor,m.htfactor
PRIVATE m.str_data,m.str_val,m.textflag,m.colorflag,m.shadowflag
PRIVATE m.memline,m.at_pos,m.i,m.r,m.lastscheme

IF (TYPE('_3D')=='C'.AND.UPPER(_3D)=='OFF').OR.TYPE('PLATFORM')#'C'.OR.;
   ALLTRIM(PLATFORM)=='DOS'.OR.ALLTRIM(PLATFORM)=='UNIX'
  GOTO BOTTOM
  RETURN .F.
ENDIF
m.c_3d='*:3D'
m.c_no3d='*:NO3D'
m.c_get3d='*:GET3D'
m.c_say3d='*:SAY3D'
m.c_pict3d='*:PICTURE3D'
m.c_box3d='*:BOX3D'
m.c_inset3d='*:INSET3D'
m.c_raised3d='*:RAISED3D'
m.c_all3d='*:ALL3D'
m.c_text3d='*:TEXT3D'
m.c_box='BOX'
m.c_color='COLOR'
m.c_rgb='RGB('
m.c_ins='*:INS'
IF RECNO()<m.r_scxdata
  IF TYPE('_DOS')#'L'.OR._DOS.OR._UNIX
    =warning('['+ALLTRIM(PLATFORM)+'] platform 3D effects cannot be '+;
             'generated from this platform')
  ENDIF
  IF linesearch('*:SET BORDERGETS',.T.)==m.null
    REPLACE PJXDATA.NOLOGO WITH .F.
  ENDIF
  IF .NOT.PJXDATA.NOLOGO.AND.linesearch('SET READ',.T.)==m.null
    REPLACE SETUPCODE WITH SETUPCODE+m.cr_lf+'SET READBORDER OFF'
  ENDIF
  IF .NOT.linesearch(m.c_no3d,.T.)==m.null
    GOTO BOTTOM
    RETURN .F.
  ENDIF
  FOR m.i = 1 TO 2
    IF m.i=2
      m.str_data=linesearch(m.c_all3d,.T.)
      IF m.str_data==m.null
        EXIT
      ENDIF
    ENDIF
    IF m.i=1
      m.str_data=linesearch(m.c_get3d,.T.)
    ENDIF
    IF .NOT.m.str_data==m.null
      m.r=RECNO()
      SKIP
      SCAN REST FOR .NOT.DELETED().AND.(OBJTYPE#15.OR.OBJCODE#0).AND.;
                    .NOT.BETWEEN(OBJTYPE,5,7).AND.OBJTYPE#17.AND.;
                    OBJTYPE#23.AND.linesearch(m.c_3d)==m.null.AND.;
                    linesearch(m.c_no3d)==m.null
        REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr+lf+COMMENT
      ENDSCAN
      GOTO m.r
    ENDIF
    IF m.i=1
      m.str_data=linesearch(m.c_say3d,.T.)
    ENDIF
    IF .NOT.m.str_data==m.null
      m.r=RECNO()
      SKIP
      SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=15.AND.OBJCODE=0.AND.;
                    linesearch(m.c_3d)==m.null.AND.;
                    linesearch(m.c_no3d)==m.null
        REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr+lf+COMMENT
      ENDSCAN
      GOTO m.r
    ENDIF
    IF m.i=1
      m.str_data=linesearch(m.c_pict3d,.T.)
    ENDIF
    IF .NOT.m.str_data==m.null
      m.r=RECNO()
      SKIP
      SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=17.AND.;
                    linesearch(m.c_3d)==m.null.AND.;
                    linesearch(m.c_no3d)==m.null
        REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr+lf+COMMENT
      ENDSCAN
      GOTO m.r
    ENDIF
    IF m.i=1
      m.str_data=linesearch(m.c_box3d,.T.)
    ENDIF
    IF m.i=1.AND..NOT.m.str_data==m.null
      m.r=RECNO()
      SKIP
      SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=7.AND.STYLE=0.AND.;
                    linesearch(m.c_3d)==m.null.AND.;
                    linesearch(m.c_no3d)==m.null
        REPLACE COMMENT WITH m.c_3d+' BOX '+m.str_data+m.cr+lf+COMMENT
      ENDSCAN
      GOTO m.r
    ENDIF
    IF m.i=1
      m.str_data=linesearch(m.c_inset3d,.T.)
    ENDIF
    IF .NOT.m.str_data==m.null
      m.r=RECNO()
      SKIP
      SCAN REST FOR .NOT.DELETED().AND.(OBJTYPE=6.OR.OBJTYPE=7).AND.;
                    linesearch(m.c_3d)==m.null.AND.;
                    linesearch(m.c_no3d)==m.null
        REPLACE COMMENT WITH m.c_3d+' INSET '+m.str_data+m.cr+lf+COMMENT
      ENDSCAN
      GOTO m.r
    ELSE
      IF m.i=1
        m.str_data=linesearch(m.c_raised3d,.T.)
        IF .NOT.m.str_data==m.null
          m.r=RECNO()
          SKIP
          SCAN REST FOR .NOT.DELETED().AND.(OBJTYPE=6.OR.OBJTYPE=7).AND.;
                        linesearch(m.c_3d)==m.null.AND.;
                        linesearch(m.c_no3d)==m.null
            REPLACE COMMENT WITH m.c_3d+' RAISED '+m.str_data+m.cr+lf+COMMENT
          ENDSCAN
          GOTO m.r
        ENDIF
      ENDIF
    ENDIF
  ENDFOR
  m.str_data=linesearch(m.c_text3d,.T.)
  IF .NOT.m.str_data==m.null
    m.r=RECNO()
    SKIP
    SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=5.AND.;
                  linesearch(m.c_3d)==m.null.AND.;
                  linesearch(m.c_no3d)==m.null
      REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr+lf+COMMENT
    ENDSCAN
    GOTO m.r
  ENDIF
  RETURN .T.
ENDIF
IF .NOT.drvobj().OR.EMPTY(COMMENT).OR..NOT.linesearch(m.c_no3d)==m.null.OR.;
   .NOT.linesearch(m.c_ins)==m.null
  RETURN .F.
ENDIF
m.r=RECNO()
m.str_data=linesearch(m.c_3d)
IF m.str_data==m.null
  RETURN .F.
ENDIF
m.str_val=VAL(m.str_data)
m.textflag=(OBJTYPE=5.OR.(OBJTYPE=15.AND.OBJCODE=0))
m.cfontstylm=IIF(m.fontstyle=1.OR.m.fontstyle=3,'B','')
m.cfontstyl=IIF(FONTSTYLE=1.OR.FONTSTYLE=3,'B','')
m.shadered=128
m.shadegreen=128
m.shadeblue=128
m.colorflag=.F.
m.shadowflag=.F.
m.at_pos=ATC(m.c_rgb,m.str_data)
IF m.at_pos=0
  m.at_pos=ATC(m.c_color,m.str_data)
  IF m.at_pos>0
    m.memline=PADR(UPPER(ALLTRIM(SUBSTR(ALLTRIM(m.str_data),m.at_pos+;
              LEN(m.c_color),3))),3)
    IF INLIST(m.memline,'N  ','N+ ','X  ','B  ','B+ ','GR ','GR+','BG ','BG+',;
              'G  ','G+ ','RB ','RB+','R  ','R+ ','B  ','B+ ','W  ','W+ ')
      m.lastscheme=SCHEME(17,1)
      SET COLOR OF SCHEME 17 TO (m.memline)
      m.str_data=m.str_data+' '+RGBSCHEME(17,1)
      SET COLOR OF SCHEME 17 TO (m.lastscheme)
    ENDIF
  ENDIF
ENDIF
m.at_pos=ATC(m.c_color,m.str_data)
IF m.at_pos>0
  m.memline=SUBSTR(m.str_data,m.at_pos+LEN(m.c_color))
  m.at_pos=ATC(m.c_rgb,m.memline)
  IF m.at_pos>0
    m.colorflag=.T.
    m.shadered=0
    m.shadegreen=0
    m.shadeblue=0
    m.memline=SUBSTR(m.memline,m.at_pos+LEN(m.c_rgb))
    m.shadered=VAL(m.memline)
    m.at_pos=AT(',',m.memline)
    IF m.at_pos>0
      m.memline=SUBSTR(m.memline,m.at_pos+1)
      m.shadegreen=VAL(m.memline)
      m.at_pos=AT(',',m.memline)
      IF m.at_pos>0
        m.memline=SUBSTR(m.memline,m.at_pos+1)
        m.shadeblue=VAL(m.memline)
      ENDIF
    ENDIF
  ENDIF
ENDIF
m.vfontratio=FONTMETRIC(1,'MS Sans Serif',8,'N')/;
             FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)*;
             FONTMETRIC(1,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
             FONTMETRIC(1,'FoxFont',9,'N')
m.hfontratio=FONTMETRIC(6,'MS Sans Serif',8,'N')/;
             FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)*;
             FONTMETRIC(6,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
             FONTMETRIC(6,'FoxFont',9,'N')
IF m.textflag
  m.vfactor=2
  m.hfactor=2
ELSE
  m.vfactor=4
  m.hfactor=4
ENDIF
m.htfactor=1
m.wdfactor=1
IF m.str_val#0
  m.vfactor=m.str_val
  m.hfactor=m.str_val
ENDIF
DO CASE
  CASE OBJTYPE=6.OR.OBJTYPE=7
    m.at_pos=ATC(m.c_box,m.str_data)
    IF OBJTYPE=7.AND.STYLE=0.AND.m.at_pos>0
      m.str_data=SUBSTR(m.str_data,m.at_pos+LEN(m.c_box))
      IF .NOT.EMPTY(m.str_data).AND.','$m.str_data.AND.;
         ATC(m.c_color,m.str_data)=0
        RETURN instxt1('DO 3DBOX WITH '+ALLTRIM(STR(VPOS,7,3))+','+;
                       ALLTRIM(STR(HPOS,7,3))+','+ALLTRIM(STR(HEIGHT,7,3))+;
                       ','+ALLTRIM(STR(WIDTH,7,3))+','+m.str_data)
      ENDIF
      m.str_val=VAL(m.str_data)
      IF m.str_val=0
        m.str_val=3
      ENDIF
      RETURN instxt1('DO 3DBOX WITH '+ALLTRIM(STR(VPOS,7,3))+','+;
                     ALLTRIM(STR(HPOS,7,3))+','+ALLTRIM(STR(HEIGHT,7,3))+','+;
                     ALLTRIM(STR(WIDTH,7,3))+','+ALLTRIM(STR(m.str_val,9,3))+;
                     ',255,255,255,'+ALLTRIM(STR(m.shadered,5))+','+;
                     ALLTRIM(STR(m.shadegreen,5))+','+ALLTRIM(STR(m.shadeblue,5)))

    ENDIF
    IF m.str_val=0
      IF PENRED=-1.AND.PENGREEN=-1.AND.PENBLUE=-1
        REPLACE PENRED WITH 255, PENGREEN WITH 255, PENBLUE WITH 255
      ENDIF
      DO CASE
        CASE ATC('INSET',m.str_data)>0
          m.vfactor=-1
          m.hfactor=-1
        CASE ATC('RAISED',m.str_data)>0
          m.vfactor=1
          m.hfactor=1
        OTHERWISE
          m.vfactor=-1
          m.hfactor=-1
      ENDCASE
    ENDIF
    SCATTER TO a_fscatter MEMO
    =insblank(-1)
    GATHER FROM a_fscatter MEMO
    REPLACE VPOS WITH MAX(VPOS+m.vfontratio*m.vfactor*(SROWS()/SYSMETRIC(1)),0),;
            HPOS WITH MAX(HPOS+m.hfontratio*m.hfactor*(SCOLS()/SYSMETRIC(2)),0),;
            PENRED WITH m.shadered, PENGREEN WITH m.shadegreen,;
            PENBLUE WITH m.shadeblue,;
            FILLRED WITH m.shadered, FILLGREEN WITH m.shadegreen,;
            FILLBLUE WITH m.shadeblue
    SKIP
  CASE OBJTYPE=5.OR.OBJTYPE=11.OR.OBJTYPE=15.OR.OBJTYPE=16.OR.OBJTYPE=17.OR.;
       OBJTYPE=22
    IF m.str_val#0.AND.OBJTYPE=22
      m.str_val=0
    ENDIF
    IF .NOT.m.textflag.AND.m.str_val=0.AND.FILLRED=-1.AND.FILLGREEN=-1.AND.;
       FILLBLUE=-1
      REPLACE FILLRED WITH 255, FILLGREEN WITH 255, FILLBLUE WITH 255
    ENDIF
    SCATTER TO a_fscatter MEMO
    =insblank(-1)
    GATHER FROM a_fscatter MEMO
    IF m.textflag.AND.m.str_val=0.AND.MODE=1
      DO CASE
        CASE ATC('INSET',m.str_data)>0
          m.str_val=-1
          m.vfactor=-1
          m.hfactor=-1
        CASE ATC('RAISED',m.str_data)>0
          m.str_val=1
          m.vfactor=1
          m.hfactor=1
      ENDCASE
    ENDIF
    IF m.str_val=0
      IF (OBJTYPE=15.AND.OBJCODE=2).OR.OBJTYPE=11
        m.htfactor=4*m.vfontratio/;
                   (FONTMETRIC(1,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
                   FONTMETRIC(1,'FoxFont',9,'N'))
        m.wdfactor=4*m.hfontratio/;
                   (FONTMETRIC(6,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
                   FONTMETRIC(6,'FoxFont',9,'N'))
        IF OBJTYPE=15
          REPLACE VPOS WITH VPOS-m.vfontratio*2*(SROWS()/SYSMETRIC(1)),;
                  HPOS WITH HPOS-m.vfontratio*2*(SCOLS()/SYSMETRIC(2))
          IF SCROLLBAR
            m.wdfactor=m.wdfactor-1
          ENDIF
        ENDIF
        REPLACE HEIGHT WITH HEIGHT+m.vfontratio*m.htfactor*(SROWS()/SYSMETRIC(1)),;
                WIDTH WITH WIDTH+m.hfontratio*m.wdfactor*(SCOLS()/SYSMETRIC(2))
      ENDIF
      m.vfactor=-4*(SROWS()/SYSMETRIC(1))
      m.hfactor=-4*(SCOLS()/SYSMETRIC(2))
      IF OBJTYPE=17
        m.htfactor=1
        m.wdfactor=1
      ELSE
        m.htfactor=FONTMETRIC(1,FONTFACE,FONTSIZE,m.cfontstyl)/;
                   FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)
        m.wdfactor=FONTMETRIC(6,FONTFACE,FONTSIZE,m.cfontstyl)/;
                   FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)
      ENDIF
      m.vfactor=m.vfontratio*m.vfactor
      m.hfactor=m.hfontratio*m.hfactor
      REPLACE VPOS WITH MAX(VPOS+m.vfactor,0),;
              HPOS WITH MAX(HPOS+m.hfactor,0),;
              HEIGHT WITH m.htfactor*HEIGHT-2*m.vfactor,;
              WIDTH WITH m.wdfactor*WIDTH-2*m.hfactor
      IF OBJTYPE=11.AND.m.htfactor#1
        REPLACE HEIGHT WITH HEIGHT-(2*m.vfontratio*m.vfactor/m.htfactor)
      ENDIF
      DO CASE
        CASE OBJTYPE=22
          m.cbevel='-2'
        CASE m.textflag
          m.cbevel='-3'
        OTHERWISE
          m.cbevel='-4'
      ENDCASE
      IF .NOT.m.colorflag
        IF OBJTYPE=22
          m.shadered=128
          m.shadegreen=128
          m.shadeblue=128
        ELSE
          m.shadered=96
          m.shadegreen=96
          m.shadeblue=96
        ENDIF
      ENDIF
      IF instxt1('DO 3DBOX WITH '+ALLTRIM(STR(VPOS,7,3))+','+;
                 ALLTRIM(STR(HPOS,7,3))+','+ALLTRIM(STR(HEIGHT,7,3))+','+;
                 ALLTRIM(STR(WIDTH,7,3))+','+m.cbevel+',255,255,255,'+;
                 ALLTRIM(STR(m.shadered,5))+','+ALLTRIM(STR(m.shadegreen,5))+;
                 ','+ALLTRIM(STR(m.shadeblue,5)))
        SKIP
        RETURN .T.
      ELSE
        =delobj1()
        RETURN .F.
      ENDIF
    ENDIF
    IF OBJTYPE=11.OR.OBJTYPE=16
      m.htfactor=FONTMETRIC(1,FONTFACE,FONTSIZE,m.cfontstyl)/;
                 FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)
      m.wdfactor=FONTMETRIC(6,FONTFACE,FONTSIZE,m.cfontstyl)/;
                 FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)
      IF OBJTYPE=11
        m.htfactor=1.07*m.htfactor
        m.wdfactor=1.0125*m.wdfactor
      ENDIF
    ENDIF
    DO CASE
      CASE m.textflag
        =.F.
      CASE OBJTYPE=15
        IF OBJCODE=2
          REPLACE VPOS WITH VPOS-m.vfontratio*2*(SROWS()/SYSMETRIC(1)),;
                  HPOS WITH HPOS-m.hfontratio*2*(SCOLS()/SYSMETRIC(2)),;
                  HEIGHT WITH HEIGHT+4*(SROWS()/SYSMETRIC(1)),;
                  WIDTH WITH WIDTH+IIF(SCROLLBAR,2,4)*(SCOLS()/SYSMETRIC(2))
        ENDIF
        REPLACE NAME WITH 'm.null'+ALLTRIM(STR(RECNO(),6)),;
                OBJCODE WITH 1, PICTURE WITH '', INITIALVAL WITH ''
      OTHERWISE
        REPLACE NAME WITH '', EXPR WITH '', OBJTYPE WITH 7, OBJCODE WITH 4,;
                STYLE WITH 0, PICTURE WITH '', INITIALVAL WITH '',;
                PENSIZE WITH 1, PENPAT WITH 8, FILLPAT WITH 1, FILLCHAR WITH ' ',;
                FONTFACE WITH '', FONTSTYLE WITH 0, FONTSIZE WITH 8
    ENDCASE
    REPLACE VPOS WITH MAX(VPOS+m.vfontratio*m.vfactor*(SROWS()/SYSMETRIC(1)),0),;
            HPOS WITH MAX(HPOS+m.hfontratio*m.hfactor*(SCOLS()/SYSMETRIC(2)),0),;
            HEIGHT WITH m.htfactor*HEIGHT, WIDTH WITH m.wdfactor*WIDTH,;
            PENRED WITH m.shadered, PENGREEN WITH m.shadegreen,;
            PENBLUE WITH m.shadeblue,;
            FILLRED WITH m.shadered, FILLGREEN WITH m.shadegreen,;
            FILLBLUE WITH m.shadeblue,;
            WHENTYPE WITH 0, WHEN WITH '.F.', VALID WITH '',;
            MESSAGE WITH '', ERROR WITH '', RANGELO WITH '',;
            RANGEHI WITH '', DISABLED WITH .F., SCROLLBAR WITH .F.,;
            INITIALVAL WITH "''"
    SKIP
    RELEASE a_fscatter
    m.shadowflag=.T.
  CASE OBJTYPE=13.AND.m.str_val=0
    IF FILLRED=-1.AND.FILLGREEN=-1.AND.FILLBLUE=-1
      REPLACE FILLRED WITH m.fillred, FILLGREEN WITH m.fillgreen,;
              FILLBLUE WITH m.fillblue
    ENDIF
    RETURN .T.
  CASE OBJTYPE=14
    IF FONTSTYLE=0
      RETURN .F.
    ENDIF
    SCATTER TO a_fscatter MEMO
    =insblank(-1)
    GATHER FROM a_fscatter MEMO
    IF m.str_val=0
      m.vfactor=-1
      m.hfactor=-1
      m.shadered=0
      m.shadegreen=0
      m.shadeblue=0
    ENDIF
    REPLACE NAME WITH 'm.null'+ALLTRIM(STR(RECNO(),6)),;
            VPOS WITH MAX(VPOS+m.vfontratio*m.vfactor*(SROWS()/SYSMETRIC(1)),0),;
            HPOS WITH MAX(HPOS+m.hfontratio*m.hfactor*(SCOLS()/SYSMETRIC(2)),0),;
            PENRED WITH m.shadered, PENGREEN WITH m.shadegreen,;
            PENBLUE WITH m.shadeblue,;
            FILLRED WITH m.shadered, FILLGREEN WITH m.shadegreen,;
            FILLBLUE WITH m.shadeblue,;
            WHENTYPE WITH 0, WHEN WITH '.F.', VALID WITH '',;
            MESSAGE WITH '', ERROR WITH '', RANGELO WITH '',;
            RANGEHI WITH '', PICTURE WITH CHR(34)+"@*C  "+CHR(34),;
            DISABLED WITH .T., INITIALNUM WITH 0
    SKIP
    RELEASE a_fscatter
  OTHERWISE
    RETURN .F.
ENDCASE
IF OBJTYPE=17.AND.MODE=1.AND.m.shadowflag
  m.vfactor=VPOS
  m.hfactor=HPOS
  m.htfactor=HEIGHT-m.vfontratio*(SROWS()/SYSMETRIC(1))
  m.wdfactor=WIDTH-m.hfontratio*(SCOLS()/SYSMETRIC(2))
  SKIP -1
  SCATTER TO a_fscatter MEMO
  SKIP
  =insblank(-1)
  GATHER FROM a_fscatter MEMO
  REPLACE VPOS WITH m.vfactor, HPOS WITH m.hfactor,;
          HEIGHT WITH m.htfactor, WIDTH WITH m.wdfactor;
          PENRED WITH 255, PENGREEN WITH 255, PENBLUE WITH 255,;
          FILLRED WITH 255, FILLGREEN WITH 255, FILLBLUE WITH 255
  SKIP
ENDIF
RETURN .T.

* END 3D.PRG
