//**************************************************************************
//
// Sample3D - Shows the use of CTL3D.DLL
//
// Yes it is really this easy.
//
//
//**************************************************************************

#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include "ctl3d.h"

extern const HINSTANCE _hInstance ;
HWND hwndApp;

char szFilterSpec [128] =                       // file type filters
             "Text Files (*.TXT)\0*.TXT\0All Files (*.*)\0*.*\0";

char szFileName[120];

BOOL FAR PASCAL OpenHook(HWND hwnd, int wm, int wParam, long lParam)
{
    switch (wm) {
	case WM_INITDIALOG:
            // We must call this to subclass the directory listbox even
            // if the app calls Ctl3dAutoSubclass (commdlg bug)
            Ctl3dSubclassDlg(hwnd, CTL3D_ALL);
        break;
    }
    return FALSE;
}


void FileOpen(HWND hwndOwner)
{
    OPENFILENAME ofn;

    /* fill in non-variant fields of OPENFILENAME struct. */
    ofn.lStructSize       = sizeof(OPENFILENAME);
    ofn.hwndOwner	  = hwndOwner;
    ofn.lpstrFilter	  = szFilterSpec;
    ofn.lpstrCustomFilter = NULL;
    ofn.nMaxCustFilter	  = 0;
    ofn.nFilterIndex	  = 1;
    ofn.lpstrFile         = szFileName;
    ofn.nMaxFile	  = 120;
    ofn.lpstrInitialDir   = NULL;
    ofn.lpstrFileTitle    = NULL;
    ofn.nMaxFileTitle     = 120;
    ofn.lpstrTitle        = "3D Look";
    ofn.lpstrDefExt       = "TXT";
    ofn.Flags = OFN_HIDEREADONLY | OFN_ENABLEHOOK;
         ofn.lpfnHook = MakeProcInstance(OpenHook, _hInstance);
    ofn.lCustData = 0;
    ofn.lpTemplateName = 0;

    GetOpenFileName ((LPOPENFILENAME)&ofn);
    FreeProcInstance(ofn.lpfnHook);
}


//
// Dialog Procedure
//
BOOL FAR PASCAL DialogProc(HWND hdlg, UINT wm, WPARAM wParam, LPARAM lParam)
{
    switch(wm) {
	default:
            return FALSE;

        case WM_SYSCOLORCHANGE:
           Ctl3dColorChange();
           break;

	case WM_COMMAND:
            if (wParam == IDOK) {
                EndDialog(hdlg, TRUE);
            }
            else if (wParam == 130 ) {
                MessageBox(hdlg, "This is a sample Message Box","3D Look", MB_OK);
            }
            else if (wParam == 131 ) {
                FileOpen(hdlg);
            }
            break;
    }

    return TRUE;
}




//
// This sample uses main() instead of WinMain
//
void main( int argc, char *argv[], char **envp )
{
   FARPROC lpproc;

   Ctl3dRegister(_hInstance);
   Ctl3dAutoSubclass(_hInstance);

   lpproc = MakeProcInstance((FARPROC) DialogProc, _hInstance);
   DialogBox(_hInstance, MAKEINTRESOURCE(100), NULL, lpproc);
   FreeProcInstance(lpproc);

   Ctl3dUnregister(_hInstance);
   return;
}
