#include <windows.h>
#include <shellapi.h> 
#include "wprint.h"

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
	MSG msg;

	hInst = hInstance;

	if (hPrevInstance)
		 return (FALSE);

	if (!InitApplication(hInstance))
		 return (FALSE);

	if (!InitInstance(hInstance, nCmdShow))
		 return (FALSE);

	 hAccel  =  LoadAccelerators ( hInstance, "WinPrintAccels") ;
	 while (GetMessage ( &msg, NULL, 0, 0 ))
			{
			if ( !TranslateAccelerator ( hWndParent, hAccel, &msg ))
				 {
				 TranslateMessage ( &msg ) ;
				 DispatchMessage ( &msg ) ;
				 }
			}
	return (msg.wParam);
}


BOOL InitApplication(hInstance)
HANDLE hInstance;
{
	WNDCLASS  wc;

	wc.style = CS_VREDRAW | CS_HREDRAW;
	wc.lpfnWndProc = MainWndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance,"WinPrintIcon");
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName = NULL ;
	wc.lpszClassName = "WinPrint";

	return (RegisterClass(&wc));

}

BOOL InitInstance(hInstance, nCmdShow)
	HANDLE          hInstance;
	int             nCmdShow;
{
	HWND            hWnd;
	HMENU           hMenu;

	hInst = hInstance;

	hWnd = CreateWindow("WinPrint","WPrint",WS_OVERLAPPEDWINDOW,
	CW_USEDEFAULT,CW_USEDEFAULT,0,0,
	NULL,NULL,hInstance,NULL);

	if (!hWnd)
	return (FALSE);

	hWndParent = hWnd ;

	hMenu = GetSystemMenu (hWndParent, 0);

	AppendMenu (hMenu, MF_SEPARATOR, 0, NULL);
	AppendMenu (hMenu, MF_STRING, IDM_SETTINGS, "&Settings...\tF5\0");
	AppendMenu (hMenu, MF_STRING, IDM_PRINT, "&Print file...\tF6\0");
	AppendMenu (hMenu, MF_STRING, IDM_ABOUT, "A&bout WPrint...\tF1\0");
	
	RemoveMenu (hMenu, SC_MINIMIZE, MF_BYCOMMAND);
	RemoveMenu (hMenu, SC_MAXIMIZE, MF_BYCOMMAND);
	RemoveMenu (hMenu, SC_SIZE, MF_BYCOMMAND);

	DragAcceptFiles(hWnd, TRUE);

	ShowWindow(hWnd, SW_SHOWMINIMIZED);
	UpdateWindow(hWnd);
	return (TRUE);

}

VOID  CenterWindow (hDlg)
HWND  hDlg;
{
  RECT rc;

  GetWindowRect(hDlg,&rc);
  SetWindowPos(hDlg,NULL,
   (GetSystemMetrics(SM_CXSCREEN) - (rc.right - rc.left)) / 2,
   (GetSystemMetrics(SM_CYSCREEN) - (rc.bottom - rc.top)) / 3,
	0, 0, SWP_NOSIZE | SWP_NOACTIVATE);
}


BOOL Error (int i)
{
char sz [80];
	if (i){
		LoadString (hInst, i, sz, sizeof (sz));
		MessageBox (NULL, sz, "Error", MB_OK|MB_TASKMODAL);
		return TRUE;
	}
	return FALSE;
}
