#include <windows.h>
#include <shellapi.h> 
#include <direct.h>
#include <errno.h>
#include "wprint.h"

/////////////////////////////////////////////////////////////////////////
//
//  MainWndProc - window procedure for parent window
//
//  hWnd: Handle of parent window.
//  message: message number WM_?
//  wParam: word containing extra information about message param.
//  lParam: dword containing extra information about message param.
//
/////////////////////////////////////////////////////////////////////////

long FAREXPORT MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{
    switch (message) {
      case WM_CREATE:
      {
        int nScaling = GetProfileInt ((LPSTR)"WinPrint\0",
                                    (LPSTR)"Scale\0",
                                    (int)-1) - 1;
        int nMagnifyBy = GetProfileInt ((LPSTR)"WinPrint\0",
                                    (LPSTR)"MagnifyBy\0",
                                    (int)-1) ;
        if (nScaling < 0 || nMagnifyBy < 0)
                PostMessage (hWnd, WM_SYSCOMMAND, IDM_SETTINGS, 0L);
      }
      break ;
      
      case WM_DROPFILES:

         if ((wNumDrop = DragQueryFile (wParam,-1,NULL,0)) > 0){

            if (NULL==(hDragList = GlobalAlloc (GHND, sizeof (DRAGLIST) * wNumDrop))){
                Error (IDS_NOALLOC);
                goto DragErr0;
            }

            if (NULL==(lpDragList = (LPDRAGLIST) GlobalLock (hDragList))){
                Error (IDS_NOLOCK);
                goto DragErr1;
            }

            for (i = 0; i < (int) wNumDrop; i++) 
                DragQueryFile (wParam,i,lpDragList[i].szFileName,FILE_NAME_SIZE);

            PrintDragList ();

            GlobalUnlock (hDragList) ;
DragErr1:
            GlobalFree (hDragList) ;
         }
DragErr0:

         break;

      case WM_QUERYOPEN:
         /* When the user double-clicks on the icon, I get a 
            WM_QUERYOPEN message.  All I do from here is
            display a dialog box which shows printer settings */
         PostMessage (hWnd, WM_SYSCOMMAND, IDM_SETTINGS, 0L);
         return 0L;

        case WM_SYSCOMMAND:
            switch (wParam){
                FARPROC lp;
                case IDM_ABOUT:
                    lp = MakeProcInstance(About, hInst);
                    DialogBox (hInst,"ABOUTBOX",hWnd,lp);
                    FreeProcInstance (lp);
                    break ;
                case IDM_SETTINGS:
                    lp = MakeProcInstance (INIDlgProc, hInst);
                    DialogBox (hInst, "Settings", hWndParent, lp);
                    FreeProcInstance (lp);
                    break ;
                case IDM_PRINT:
                    eszFile[0] = '\0';       
                    _getcwd (eszDirName,sizeof(eszDirName));                    
                    
                    eofn.lStructSize = sizeof (OPENFILENAME);
                    eofn.hwndOwner = hWnd;
                    eofn.lpstrFilter = eszFilter[0];
                    eofn.lpstrCustomFilter = (LPSTR) NULL;
                    eofn.nMaxCustFilter = 0L;
                    eofn.nFilterIndex = 1L;
                    eofn.lpstrFile = eszFile;
                    eofn.nMaxFile = sizeof (eszFile);
                    eofn.lpstrFileTitle = eszFileTitle;
                    eofn.nMaxFileTitle = sizeof (eszFileTitle);
                    eofn.lpstrInitialDir = eszDirName;
                    eofn.lpstrTitle = (LPSTR)"WinPrint Print File...\0";
                    eofn.Flags = 0;
                    eofn.nFileOffset = 0;
                    eofn.nFileExtension = 0;
                    eofn.lpstrDefExt = (LPSTR)NULL;

                    if (GetOpenFileName(&eofn)){
                        if (NULL==(hDragList = 
                                   GlobalAlloc (GHND, sizeof (DRAGLIST)))){
                            Error (IDS_NOALLOC);
                            break;
                        }

                        if (NULL==(lpDragList = 
                                   (LPDRAGLIST) GlobalLock (hDragList))){
                            Error (IDS_NOLOCK);
                            GlobalUnlock (hDragList);GlobalFree(hDragList);
                            break;
                        }
                        lstrcpy (lpDragList[0].szFileName,eszFile);
                        wNumDrop = 1;
                        PrintDragList();
                        GlobalUnlock (hDragList);GlobalFree(hDragList);
                    }
                    return 0L;

                    break ;
                default:
                    break ;
            }
            break ;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;
    }
    return (DefWindowProc(hWnd, message, wParam, lParam));
}


