/**************************************
 * ptyopen.c : open a BSD-style pty
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 **************************************/

#include <errno.h>
#include <fcntl.h>

#include "ptyopen.h"

int PtyOpen(ptyFd,ttyName)
int *ptyFd;
char **ttyName;
{
  static char ptem[]  = "/dev/ptyXX";
  static char ttem[]  = "/dev/ttyXX";
  static char letter[] = "pqrstuvwxy";
  static char digit[]  = "0123456789abcdef";
  char *l, *d;

  for (l = letter; *l ;l++)
    for (d = digit; *d ;d++)
      {
	ptem[8] = *l;
	ptem[9] = *d;
    
	*ptyFd = open(ptem,O_RDWR);
	if (*ptyFd < 0)
	  {
	    if (errno == ENOENT)
	      return(-1);
	  }
	else
	  {     
	    ttem[8] = *l;
	    ttem[9] = *d;
	    *ttyName = ttem;
	    
	    if (!access(ttem,6))
	      return(0);

	    close(*ptyFd);
	  }
      }

  return(-1);
}


