/**************************************
 * fnconv.c : convert filenames
 *
 * Copyright (C) 1992 Jouni Leppjrvi
 **************************************/

#include <ctype.h>
#include "fnconv.h"

/*
 * FnConv() converts filenames so that
 * they are 'useful' under both DOS and
 * unix. The conversion is done into
 * the argument buffer, because the
 * filename never gets longer in the
 * conversion.
 */

void FnConv(name)
char *name;
{
    int i, j, k;

    for (i = 0; name[i] ;i++)
        if (isupper(name[i]))
            name[i] = tolower(name[i]);

    if (name[0] == '.')
        name[0] = '_';

    for (i = 0; i < 8 && name[i] && name[i] != '.' ;i++);

    if (!name[i])
        return;

    for (j = k = i; name[j] ;j++)
        if (name[j] == '.')
            k = j;

    if (name[k] != '.' || (name[k] == '.' && !name[k + 1]))
    {
        name[i] = '\0';
        return;
    }

    name[i] = '.';

    for (j = 1; j < 4 ;j++)
        name[i + j] = name[k + j];

    name[i + j] = '\0';
}

