/*********************************************
 * mtime.c : real time in milliseconds
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 *********************************************/

#include <sys/time.h>
#include "connect.h"

unsigned long mtime()
{
  static long _t = 0;
  struct timeval stv;

/* Dynix/ptx specific routine... requires -lseq at compile time */

  get_process_stats(&stv, getpid(), 0, 0);

  if (!_t)
    _t = stv.tv_sec;

  return(((stv.tv_sec - _t) * 1000) + ( stv.tv_usec / 1000));
}
