/*****************************************************
 * tty.c : Aix tty handling (basicly posix ..)
 *
 * by Jouni Lepp{j{rvi (C) 1992
 *****************************************************/

#include <termios.h>
#include "tty.h"

static struct termios _oldParams;

void TtyStore()
{
  tcgetattr(0,&_oldParams);
}

void TtyRestore()
{
  tcsetattr(0,TCSAFLUSH,&_oldParams); 
}

void TtyRaw()
{
  struct termios params;

  params = _oldParams;

  params.c_cc[VMIN] = 0;
  params.c_cc[VTIME] = 0;
  params.c_iflag = 0;
  params.c_oflag = 0;
  params.c_lflag = 0;

  tcsetattr(0,TCSAFLUSH,&params);
}

void TtySetSize(fd,cx,cy)
int fd, cx, cy;
{
#ifdef TIOCSWINSZ
  static struct winsize ws;

  ws.ws_row = cy;
  ws.ws_col = cx;
  ioctl(fd,TIOCSWINSZ,&ws);
#endif
}

void TtySane()
{
  TtyRestore();
}

