/**************************************
 * sleep.c : "short sleep" (AIX)
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 *
 * Sleep() is realized with select()
 * which enables syncronization
 * to incoming data and should result
 * in better performance when line
 * delay is of critical length.
 **************************************/

#include <stdio.h>
#include <sys/select.h> /* AIX needs this */
#include <sys/types.h>
#include <sys/time.h>

#define SLEEP_INTERVAL 100

void Sleep()
{
  struct fd_set fds;
  struct timeval tv;

  tv.tv_sec  = 0L;
  tv.tv_usec = SLEEP_INTERVAL * 1000L;
  FD_ZERO(&fds);
  FD_SET(0,&fds);

  select(1,&fds,NULL,&fds,&tv);
}
