//---------------------------------------------------------------------------
//
//	File:			LOGSPAL.CPP
//	Programmer: 	Bob Provencher
//	Create Date:	1/15/95
//	Last Mod Date:	3/5/95
//	Description:	LogSystemPalette class implementation
//
//	Copyright (c) 1994, 1995. Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#include "logspal.h"

const COLORREF rgbBlack = RGB(   0,   0,   0 );
const COLORREF rgbWhite = RGB( 255, 255, 255 );

COLORREF LogSystemPalette::statColors[ COLOR_BTNHIGHLIGHT + 1 ];
COLORREF LogSystemPalette::bwColorMap[ COLOR_BTNHIGHLIGHT + 1 ] =
{
	rgbWhite,					// COLOR_SCROLLBAR            0
	rgbWhite,					// COLOR_BACKGROUND           1
	rgbWhite,					// COLOR_ACTIVECAPTION        2
	rgbBlack,					// COLOR_INACTIVECAPTION      3
	rgbWhite,					// COLOR_MENU                 4
	rgbWhite,					// COLOR_WINDOW               5
	rgbBlack,					// COLOR_WINDOWFRAME          6
	rgbBlack,					// COLOR_MENUTEXT             7
	rgbBlack,					// COLOR_WINDOWTEXT           8
	rgbBlack,					// COLOR_CAPTIONTEXT          9
	rgbBlack,					// COLOR_ACTIVEBORDER        10
	rgbWhite,					// COLOR_INACTIVEBORDER      11
	rgbWhite,					// COLOR_APPWORKSPACE        12
	rgbBlack,					// COLOR_HIGHLIGHT           13
	rgbWhite,					// COLOR_HIGHLIGHTTEXT       14
	rgbWhite,					// COLOR_BTNFACE             15
	rgbBlack,					// COLOR_BTNSHADOW           16
	rgbBlack,					// COLOR_GRAYTEXT            17
	rgbBlack,					// COLOR_BTNTEXT             18
	rgbWhite,					// COLOR_INACTIVECAPTIONTEXT 19
	rgbWhite					// COLOR_BTNHIGHLIGHT        20
};

void LogSystemPalette::SaveColors()
{
	int elem[ COLOR_BTNHIGHLIGHT + 1 ];
	for ( int i = COLOR_SCROLLBAR; i < COLOR_BTNHIGHLIGHT + 1; i++ )
	{
		statColors[ i ] = GetSysColor( i );
		elem[ i ] = i;
	}
	SetSysColors( COLOR_BTNHIGHLIGHT + 1, elem, bwColorMap );
}

void LogSystemPalette::RestoreColors()
{
	int elem[ COLOR_BTNHIGHLIGHT + 1 ];
	for ( int i = COLOR_SCROLLBAR; i < COLOR_BTNHIGHLIGHT + 1; i++ )
		elem[ i ] = i;
	SetSysColors( COLOR_BTNHIGHLIGHT + 1, elem, statColors );
}

								   


