#ifndef __GEN_H__
#define __GEN_H__

//---------------------------------------------------------------------------
//
//  File:           GEN.H
//  Programmer:     Bob Provencher
//  Create Date:    11/27/94
//  Last Mod Date:  3/5/95
//  Description:    general purpose function prototypes
//
//  Copyright (c) 1994, 1995. Aesir Software, Inc.
//  All Rights Reserved.
//
//---------------------------------------------------------------------------

#ifndef __PRECOMP_H__
#include "precomp.h"
#endif

#if defined( __WIN32__ ) || defined( _WIN32 )
#define _hmemcpy        memcpy
#define _hmemset        memset
#define HUGE
#else
#define HUGE huge
#endif 

template <class T>
void constrain( T& x, T tmin, T tmax )
{
	x = max( tmin, min( x, tmax ) );
}

template <class T>
void swap( T& a, T& b )
{
	T temp = a;
	a = b;
	b = temp;
}

#ifdef _MSC_VER
inline int random( int x )
{
	return rand() % x;
}
inline void randomize( void )
{
	srand( clock() );
}
#endif

#endif



