//---------------------------------------------------------------------------
//
//	File:			DDSURF.CPP
//	Programmer:		Bob Provencher
//	Create Date:	6/26/95
//	Last Mod Date:	8/8/95
//	Description:	
//
//	Copyright (c) 1995 Aesir Software, Inc.
//	All Rights Reserved.
//
//---------------------------------------------------------------------------

#include "precomp.h"
#pragma hdrstop

#include "ddsurf.h"
#include "dddiag.h"
#include "ddsamp.h"
#include "dibitmap.h"
#include "logidpal.h"
#include "ball.h"

#include "ddsamp.rh"

LPDIRECTDRAWPALETTE		pPalette;			// the palette

DDSURFACEDESC			ddFlipSurfDesc;		// complex flipping structure
LPDIRECTDRAWSURFACE		pFlipSurface;		// flip surface root
DDSURFACEDESC			ddPrimSurfDesc;		// primary surface description
LPDIRECTDRAWSURFACE		pPrimarySurface;	// primary surface (the screen)
DDSURFACEDESC			ddOffSurfDesc;		// off-screen surface desc
LPDIRECTDRAWSURFACE		pOffSurface;		// off-screen surface
DDSURFACEDESC			ddOffSurf2Desc;		// off-screen surface desc #2
LPDIRECTDRAWSURFACE		pOffSurface2;		// off-screen surface #2
DDSURFACEDESC			ddBackgSurfDesc;	// background surface desc
LPDIRECTDRAWSURFACE		pBackgSurface;		// background surface
DDSURFACEDESC			ddCheckerSurfDesc;	// checker surface desc
LPDIRECTDRAWSURFACE		pCheckerSurface;	// checker surface
DDSURFACEDESC			ddBallSurfDesc;		// ball surface desc
LPDIRECTDRAWSURFACE		pBallSurface;		// ball surface
DDSURFACEDESC			ddTextSurfDesc;		// ball surface desc
LPDIRECTDRAWSURFACE		pTextSurface;		// ball surface
							  
DDCOLORKEY				ddck;				// color key

UINT					uPendingMoves;		//

HDC						hDCText;			// dc for writing text into
HBITMAP					hBmpMono;			// default mono bitmap
HBITMAP					hBmpText;			// bmp for text
LPBYTE					pBmpText;			// pointer top text bits

DWORD start, end, attempts, frame, misses; 

int  desired_fps;
int  move_ball_period;
BOOL page_flip;
int  numBackBuffs;

BOOL WaitForBltFlagOn( LPDIRECTDRAWSURFACE lpDDSurf,
					   DWORD dwFlag, DWORD timeout )
{
	DWORD start, current;
	start = timeGetTime();
	do
	{
		DDTRACE << lpDDSurf << " DirectDrawSurface::GetBltStatus()\n";
		sCode = lpDDSurf->GetBltStatus( dwFlag );
		current = timeGetTime();
	}
	while ( FAILED( sCode ) && current - start < timeout );
	DDTRACE << "Waited " << ( current - start ) << " ms for BltFlagOn.\n";
	return SUCCEEDED( sCode );
}

BOOL WaitForBltOk( LPDIRECTDRAWSURFACE lpDDSurf, DWORD timeout )
{
	return WaitForBltFlagOn( lpDDSurf, DDGBS_CANBLT, timeout );
}

BOOL WaitForBltDone( LPDIRECTDRAWSURFACE lpDDSurf, DWORD timeout )
{
	return WaitForBltFlagOn( lpDDSurf, DDGBS_ISBLTDONE, timeout );
}

BOOL WaitForFlipFlagOn( LPDIRECTDRAWSURFACE lpDDSurf,
						DWORD dwFlag, DWORD timeout )
{
	DWORD start, current;
	start = timeGetTime();
	do
	{
		DDTRACE << lpDDSurf << " DirectDrawSurface::GetFlipStatus()\n";
		sCode = lpDDSurf->GetFlipStatus( dwFlag );
		current = timeGetTime();
	}
	while ( FAILED( sCode ) && current - start < timeout );
	DDTRACE << "Waited " << ( current - start ) << " ms for FlipFlagOn.\n";
	return SUCCEEDED( sCode );
}

BOOL WaitForFlipOk( LPDIRECTDRAWSURFACE lpDDSurf, DWORD timeout )
{
	return WaitForFlipFlagOn( lpDDSurf, DDGFS_CANFLIP, timeout );
}

BOOL WaitForFlipDone( LPDIRECTDRAWSURFACE lpDDSurf, DWORD timeout )
{
	return WaitForFlipFlagOn( lpDDSurf, DDGFS_ISFLIPDONE, timeout );
}

BOOL RestoreIfLost( LPDIRECTDRAWSURFACE pDirectDrawSurface )
{
	if ( pDirectDrawSurface )
	{
		sCode = pDirectDrawSurface->IsLost();
		if ( sCode == DDERR_SURFACELOST )
		{
			DDTRACE << pDirectDrawSurface << " DirectDrawSurface::Restore()\n";
			sCode = pDirectDrawSurface->Restore();
            trace.flush();
		}
		CHECK;
    	return TRUE;
	}
	else
		return FALSE;
}

BOOL CreatePrimarySurface( void )
{

	BOOL bReturn = TRUE;

	DWORD s = timeGetTime();

		if ( page_flip )
		{

			ddFlipSurfDesc.dwSize			= sizeof( DDSURFACEDESC );
			ddFlipSurfDesc.dwFlags 		  	= DDSD_CAPS |
											  DDSD_BACKBUFFERCOUNT;
			ddFlipSurfDesc.ddsCaps.dwCaps 	= DDSCAPS_COMPLEX |
											  DDSCAPS_FLIP |
											  DDSCAPS_PRIMARYSURFACE;

			//
			//	use 2 back buffers in a triple-buffer scheme
			//

			ddFlipSurfDesc.dwBackBufferCount = numBackBuffs;

			DDTRACE << pDirectDraw << " DirectDraw::CreateSurface()\n";

			sCode = pDirectDraw->CreateSurface( &ddFlipSurfDesc, &pFlipSurface, NULL );

			CHECK;

			//
			//	get the pointers to the back buffers
			//

			DDTRACE << pDirectDraw << " DirectDraw::EnumAttachedSurfaces()\n";

			sCode = pFlipSurface->EnumAttachedSurfaces( NULL,
												EnumAttachedSurfacesCallback );

			CHECK;

			pPrimarySurface = pFlipSurface;
			ddPrimSurfDesc  = ddFlipSurfDesc;

		}
		else
		{

			//
			//	create an object for the display surface
			//

			ddPrimSurfDesc.dwSize  			= sizeof( DDSURFACEDESC );
			ddPrimSurfDesc.dwFlags 		  	= DDSD_CAPS;
			ddPrimSurfDesc.ddsCaps.dwCaps 	= DDSCAPS_PRIMARYSURFACE;

			DDTRACE << pDirectDraw << " DirectDraw::CreateSurface()\n";

			sCode = pDirectDraw->CreateSurface( &ddPrimSurfDesc,
												&pPrimarySurface, NULL );

			CHECK;

			#ifdef DRAW_ON_GDI_SURF
			DDTRACE << pDirectDraw << " DirectDraw::GetGDISurface()\n";
			sCode = pDirectDraw->GetGDISurface( &pPrimarySurface );
			#endif

			//
			//	create an off-screen surface
			//

			ddOffSurfDesc.dwSize			= sizeof( DDSURFACEDESC );
			ddOffSurfDesc.dwFlags 		  	= DDSD_CAPS | DDSD_HEIGHT |
											  DDSD_WIDTH;
			ddOffSurfDesc.ddsCaps.dwCaps 	= DDSCAPS_OFFSCREENPLAIN;
			ddOffSurfDesc.dwWidth			= uWidth;
			ddOffSurfDesc.dwHeight			= uHeight;

			sCode = pDirectDraw->CreateSurface( &ddOffSurfDesc,
												&pOffSurface, NULL );

			CHECK;

			if ( numBackBuffs > 1 )
			{

				ddOffSurf2Desc.dwSize			= sizeof( DDSURFACEDESC );
				ddOffSurf2Desc.dwFlags 		  	= DDSD_CAPS | DDSD_HEIGHT |
												  DDSD_WIDTH;
				ddOffSurf2Desc.ddsCaps.dwCaps 	= DDSCAPS_OFFSCREENPLAIN;
				ddOffSurf2Desc.dwWidth			= uWidth;
				ddOffSurf2Desc.dwHeight			= uHeight;

				DDTRACE << pDirectDraw << " DirectDraw::CreateSurface()\n";

				sCode = pDirectDraw->CreateSurface( &ddOffSurf2Desc,
													&pOffSurface2,
													NULL );

				CHECK;

			}

		}

	DWORD elapsed = timeGetTime() - s;

	DDTRACE << elapsed << " ms in CreatePrimarySurface()\n";

	return bReturn;

}

BOOL RestorePrimarySurface( void )
{
	if ( RestoreIfLost( pPrimarySurface ) )
		if ( !page_flip )
		{
			if ( RestoreIfLost( pOffSurface ) )
				if ( RestoreIfLost( pOffSurface2 ) )
					return TRUE;
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	return FALSE;
}

HRESULT CALLBACK EnumAttachedSurfacesCallback( LPDIRECTDRAWSURFACE lpDDSurface,
											   LPDDSURFACEDESC lpDDSurfDesc,
											   LPVOID )
{

	//
	//	we only need the first back buffer
	//

	if ( lpDDSurfDesc->ddsCaps.dwCaps & DDSCAPS_BACKBUFFER )
	{
		pOffSurface			= lpDDSurface;
		ddOffSurfDesc		= *lpDDSurfDesc;
        DDTRACE << "DirectDrawSurface " << pOffSurface << " found.\n";
		return DDENUMRET_CANCEL;
	}

	return DDENUMRET_OK;

}											   	

BOOL CreateBackgSurface( void )
{

	if ( pBackgSurface )
	{
		if ( !RestoreIfLost( pBackgSurface ) )
			return FALSE;
	}
	else
	{

		//
		//	create a surface to store the background bitmap
		//

		ddBackgSurfDesc.dwSize			= sizeof( DDSURFACEDESC );
		ddBackgSurfDesc.dwFlags 		= DDSD_CAPS | DDSD_HEIGHT | 
										  DDSD_WIDTH;
		ddBackgSurfDesc.ddsCaps.dwCaps 	= DDSCAPS_OFFSCREENPLAIN;
		ddBackgSurfDesc.dwWidth			= uWidth;
		ddBackgSurfDesc.dwHeight		= uHeight;

		DDTRACE << pDirectDraw << " DirectDraw::CreateSurface()\n";

		sCode = pDirectDraw->CreateSurface( &ddBackgSurfDesc, 
											&pBackgSurface, NULL );

		CHECK;

	}

	//
	//	tile the checkboard across the background bitmap
	//

	if ( !DrawBackground( 252, pCheckerSurface, ddCheckerSurfDesc ) )
		return FALSE;

	return TRUE;

}

static LogIdPalette pal;

BOOL CreateCheckerSurface( void )
{

	//
	//	load the checker board bitmap
	//

	DIBitmap 		checkerBoard;

	if ( !pCheckerSurface )
	{

		//
		//	create the checker board surface
		//

		checkerBoard.Load( IDB_CHECKER );

		ddCheckerSurfDesc.dwSize			= sizeof( DDSURFACEDESC );
		ddCheckerSurfDesc.dwFlags 		  	= DDSD_CAPS | DDSD_CKSRCBLT |
											  DDSD_HEIGHT | DDSD_WIDTH;
		ddCheckerSurfDesc.ddsCaps.dwCaps 	= DDSCAPS_OFFSCREENPLAIN;
		ddCheckerSurfDesc.dwWidth			= checkerBoard.Width();
		ddCheckerSurfDesc.dwHeight			= checkerBoard.Height();
		ddCheckerSurfDesc.ddckCKSrcBlt.dwColorSpaceLowValue  =
		ddCheckerSurfDesc.ddckCKSrcBlt.dwColorSpaceHighValue = 0;

		DDTRACE << pDirectDraw << " DirectDraw::CreateSurface()\n";

		sCode = pDirectDraw->CreateSurface( &ddCheckerSurfDesc,
											&pCheckerSurface,
											NULL );

		CHECK;

	}
	else
	{
		if ( !RestoreIfLost( pCheckerSurface ) )
			return FALSE;
	}

	if ( !pPalette )
	{

		if ( !checkerBoard.IsCreated() )
			checkerBoard.Load( IDB_CHECKER );

		pal = LogIdPalette( checkerBoard );

		//
		//	create the main palette from the checkerboard palette
		//

		DDTRACE << pDirectDraw << " DirectDraw::CreatePalette()\n";

		sCode = pDirectDraw->CreatePalette( DDPCAPS_8BIT | DDPCAPS_INITIALIZE,
											pal.Entries(), &pPalette, NULL );

		CHECK;

		//
		//	set the primary surface's palette
		//

		DDTRACE << pPrimarySurface << " DirectDrawSurface::SetPalette()\n";

		sCode = pPrimarySurface->SetPalette( pPalette );

		CHECK;

	}

	DDTRACE << pCheckerSurface << " DirectDrawSurface::Lock()\n";

	do
	{
		sCode = pCheckerSurface->Lock( NULL, &ddCheckerSurfDesc,
									   DDLOCK_SURFACEMEMORYPTR, NULL );
	}
	while ( sCode == DDERR_WASSTILLDRAWING );

	CHECK;

	//
	//	copy the checkerboard bitmap onto the checkerboard surface
	//

	if ( !checkerBoard.IsCreated() )
		checkerBoard.Load( IDB_CHECKER );

	if ( ddCheckerSurfDesc.lpSurface )
		memcpy( ddCheckerSurfDesc.lpSurface, checkerBoard.Bits(),
				checkerBoard.SizeImage() );

	DDTRACE << pCheckerSurface << " DirectDrawSurface::Unlock()\n";

	sCode = pCheckerSurface->Unlock( ddCheckerSurfDesc.lpSurface );

	CHECK;

	//
	//	set the transparent color (black) when checkerboard used
	//	as source in a blt.
	//	(CreateSurface apparently isn't recognizing DDSD_CKSRCBLT yet)
	//

	sCode = pCheckerSurface->SetColorKey( DDCKEY_SRCBLT,
										  &ddCheckerSurfDesc.ddckCKSrcBlt );

	CHECK;

	return TRUE;

}

BOOL CreateBallSurface( void )
{

	DIBitmap ballDib;

	ballDib.Load( IDB_BALL );

	//
	//	create the ball surface
	//

	ddBallSurfDesc.dwSize			= sizeof( DDSURFACEDESC );
	ddBallSurfDesc.dwFlags 		  	= DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddBallSurfDesc.ddsCaps.dwCaps 	= DDSCAPS_OFFSCREENPLAIN |
									  DDSCAPS_VIDEOMEMORY;
	ddBallSurfDesc.dwWidth			= ballDib.Width();
	ddBallSurfDesc.dwHeight			= ballDib.Height();

	sCode = pDirectDraw->CreateSurface( &ddBallSurfDesc,
										&pBallSurface, NULL );

	CHECK;

	DDTRACE << "DirectDrawSurface " << pDirectDraw << " created.\n";

	//
	//	set the transparent color (white) when ball used
	//	as source in a blt.
	//

	ddck.dwColorSpaceLowValue  =
	ddck.dwColorSpaceHighValue = 255;

	DDTRACE << pBallSurface << " DirectDrawSurface::SetColorKey()\n";

	sCode = pBallSurface->SetColorKey( DDCKEY_SRCBLT, &ddck );

	CHECK;

	return RestoreBallSurface();

}

BOOL RestoreBallSurface( void )
{

	if ( !RestoreIfLost( pBallSurface ) )
		return FALSE;

	DIBitmap ballDib( IDB_BALL );

	//
	//	lock the ball surface so we can draw on it
	//

	DDTRACE << pBallSurface << " DirectDrawSurface::Lock()\n";

	do
	{
		sCode = pBallSurface->Lock( NULL, &ddBallSurfDesc,
									DDLOCK_SURFACEMEMORYPTR, NULL );
	}
    while( sCode == DDERR_WASSTILLDRAWING );

	CHECK;

	//
	//	copy the ball bitmap onto the ball surface
	//

	if ( ddBallSurfDesc.lpSurface )
		memcpy( ddBallSurfDesc.lpSurface, ballDib.Bits(),
				ballDib.SizeImage() );

	sCode = pBallSurface->Unlock( ddBallSurfDesc.lpSurface );

	if ( sCode != DDERR_GENERIC )		// cirrus bug
	{
		CHECK;
	}

	DDTRACE << pBallSurface << " DirectDrawSurface::Unlock()\n";

	return TRUE;

}

BOOL CreateTextSurface( void )
{

	if ( !pTextSurface )
	{

		//
		//	set up the text surface
		//
	
		ddTextSurfDesc.dwSize				= sizeof( DDSURFACEDESC );
		ddTextSurfDesc.dwFlags				= DDSD_CAPS | DDSD_CKSRCBLT |
											  DDSD_HEIGHT | DDSD_WIDTH;
		ddTextSurfDesc.ddsCaps.dwCaps 		= DDSCAPS_OFFSCREENPLAIN;
		ddTextSurfDesc.dwWidth				= TEXT_WIDTH;
		ddTextSurfDesc.dwHeight				= TEXT_HEIGHT;
		ddTextSurfDesc.ddckCKSrcBlt.dwColorSpaceLowValue  =
		ddTextSurfDesc.ddckCKSrcBlt.dwColorSpaceHighValue = 255;
	
		DDTRACE << pDirectDraw << " DirectDraw::CreateSurface()\n";
	
		sCode = pDirectDraw->CreateSurface( &ddTextSurfDesc, 
											&pTextSurface, NULL );
	
		CHECK;
	
	}
	else
	{
		if ( !RestoreIfLost( pTextSurface ) )
		{
        	DDTRACE << "RestoreIfLost failed.\n" << flush;
			return FALSE;
		}
	}

	//
	//	GetDC()/ReleaseDC() are not supported in beta 1.  Use the technique
	//	found in the FOXBEAR example of writing to a DC with a DIB section
	//	and copying the bits to the surface/
	//	We have the palette, create a DIB section for writing frame rate into
	//	and a direct draw surface for displaying it.
	//

	if ( !pBmpText )
	{

		HDC hDC = GetDC( 0 );
		hDCText = CreateCompatibleDC( hDC );
		ReleaseDC( 0, hDC );

		BITMAPINFO bi;

		memset( &bi, 0, sizeof( bi ) );

		bi.bmiHeader.biSize 			= sizeof( BITMAPINFOHEADER );
		bi.bmiHeader.biWidth 			= TEXT_WIDTH;
		bi.bmiHeader.biHeight			= -1 * TEXT_HEIGHT;
		bi.bmiHeader.biPlanes			= 1;
		bi.bmiHeader.biBitCount			= 8;
		bi.bmiHeader.biCompression		= BI_RGB;
		bi.bmiHeader.biXPelsPerMeter	= 0;
		bi.bmiHeader.biYPelsPerMeter	= 0;
		bi.bmiHeader.biClrUsed			= 256;
		bi.bmiHeader.biClrImportant		= 256;
		bi.bmiHeader.biSizeImage		= TEXT_WIDTH * TEXT_HEIGHT;

		BitmapInfo bmpInfo( bi );
		bmpInfo.CopyColors( pal );

		hBmpText = CreateDIBSection( hDCText,
									 bmpInfo,
									 DIB_RGB_COLORS,
									 (LPVOID*)&pBmpText,
									 NULL,
									 0 );

		hBmpMono = SelectBitmap( hDCText, hBmpText );

	}

	//
	//	set the transparent color (white) when text used
	//	as source in a blt.
	//	(CreateSurface apparently isn't recognizing DDSD_CKSRCBLT yet)
	//

	DDTRACE << pTextSurface << " DirectDrawSurface::SetColorKey()\n";

	sCode = pTextSurface->SetColorKey( DDCKEY_SRCBLT,
									   &ddTextSurfDesc.ddckCKSrcBlt );

	CHECK;

	trace.flush();

	return TRUE;

}

BOOL CreateSurfaces( void )
{

	DDTRACE << "CreatePrimarySurface.\n" << flush;

	if ( !CreatePrimarySurface() )
	{
		DDTRACE << "CreatePrimarySurface failed.\n" << flush;
		return FALSE;
	}

	DDTRACE << "CreateBallSurface.\n" << flush;

	if ( !CreateBallSurface() )
	{
		DDTRACE << "CreateBallSurface failed.\n" << flush;
		return FALSE;
	}

	DDTRACE << "CreateCheckerSurface.\n" << flush;

	if ( !CreateCheckerSurface() )
	{
		DDTRACE << "CreateCheckerSurface failed.\n" << flush;
		return FALSE;
	}

	DDTRACE << "CreateBackgSurface.\n" << flush;

	if ( !CreateBackgSurface() )
	{
		DDTRACE << "CreateBackgSurface failed.\n" << flush;
		return FALSE;
	}

	DDTRACE << "CreateTextSurface.\n" << flush;

	if ( !CreateTextSurface() )
	{
		DDTRACE << "CreateTextSurface failed.\n" << flush;
		return FALSE;
	}

	//
	//	initialize the array of bouncing balls
	//

	if ( !ball )
	{
    	DDTRACE << "new Balls\n" << flush;
		ball = new Ball[ numBalls ];
	}

	return TRUE;

}

BOOL CleanUp( void )
{

	delete [] ball;

	if ( hDCText && hBmpMono )
		DeleteObject( SelectObject( hDCText, hBmpMono ) );
	hBmpText = 0;

	if ( hDCText )
		DeleteDC( hDCText );
	hDCText = 0;

	DDRelease( pBallSurface );
	DDRelease( pCheckerSurface );
	DDRelease( pBackgSurface );
	DDRelease( pTextSurface );

//	if ( pPrimarySurface )
//		pPrimarySurface->SetPalette( 0 );

	DDRelease( pPalette );

	if ( page_flip )
	{
		if ( pDirectDraw )
			pDirectDraw->FlipToGDISurface();
		DDRelease( pFlipSurface );
	}
	else
	{
		DDRelease( pOffSurface2 );
		DDRelease( pOffSurface );
		DDRelease( pPrimarySurface );
	}

	if ( pDirectDraw )
		pDirectDraw->RestoreDisplayMode();

//	if ( page_flip )
//	{
//		if ( pDirectDraw )
//			pDirectDraw->SetExclusiveModeOwner( DDSEMO_FULLSCREEN, FALSE );
//	}

	DDRelease( pDirectDraw );

    return TRUE;

}

//
//	GetDC/ReleaseDC are not supported in Beta 1.  Use the technique in FoxBear -
//	set up a DIB section for fonts.
//

BOOL ShowFPS( void )
{

	char buffer[ 40 ];

	if ( frame <= 1 )
		return TRUE;

	wsprintf( buffer, "%ld fps", ( frame * 1000 ) / ( end - start ) );

    DDTRACE << buffer << "\n";

	PatBlt( hDCText, 0, 0, TEXT_WIDTH, TEXT_HEIGHT, WHITENESS );
	TextOut( hDCText, 0, 0, buffer, strlen( buffer ) );

	GdiFlush();

	if ( pTextSurface->IsLost() )
		if ( !CreateTextSurface() )
			return FALSE;

	do 
	{
		DDTRACE << pTextSurface << " DirectDrawSurface::Lock()\n";
		sCode = pTextSurface->Lock( NULL, &ddTextSurfDesc,
									DDLOCK_SURFACEMEMORYPTR, NULL );
	}
    while ( sCode == DDERR_WASSTILLDRAWING );

    CHECK;

	//
	//	copy the ball bitmap onto the ball surface
	//

	if ( ddTextSurfDesc.lpSurface )
		memcpy( ddTextSurfDesc.lpSurface, pBmpText, TEXT_WIDTH * TEXT_HEIGHT );

	DDTRACE << pTextSurface << " DirectDrawSurface::Unlock()\n";

	sCode = pTextSurface->Unlock( ddTextSurfDesc.lpSurface );

	CHECK;

	DDTRACE << pOffSurface << " DirectDrawSurface::BltFast()\n";

	sCode = pOffSurface->BltFast( 0, uHeight - TEXT_HEIGHT,
								  pTextSurface, NULL, TRUE );

	CHECK;

	return TRUE;

}

BOOL ComposeImage( void )
{

	DWORD start = timeGetTime();

/*
	if ( !CreateSurfaces() )
	{
		DDTRACE << "CreateSurfaces failed.\n" << flush;
		return FALSE;
	}

	trace.flush();
*/

	if ( pOffSurface->IsLost() )
		if ( !RestorePrimarySurface() )
			return FALSE;

	if ( pBackgSurface->IsLost() )
		if ( !CreateBackgSurface() )
			return FALSE;

	DDTRACE << pOffSurface << " DirectDrawSurface::BltFast( 0, 0, "
			<< pBackgSurface << ", NULL, FALSE );\n";

	if ( !WaitForBltOk( pOffSurface ) )
    	return DIAGNOSE;

	sCode = pOffSurface->BltFast( 0, 0, pBackgSurface, NULL, FALSE );

	CHECK;

	if ( !DrawBall() )
		return FALSE;

	if ( !ShowFPS() )
		return FALSE;

	DDTRACE << ( timeGetTime() - start ) << " ms in ComposeImage()\n";

	return TRUE;
}

BOOL DrawBall( void )
{
	DWORD start = timeGetTime();
	for ( int i = 0; i < numBalls; i++ )
		if ( !ball[ i ].Draw() )
			break;
	DDTRACE << ( timeGetTime() - start ) << " ms in DrawBall()\n";
	return i == numBalls;
}

void MoveBall( void )
{
	for ( int i = 0; i < numBalls; i++ )
		ball[ i ].Move();
}

void AccelBall( void )
{
	for ( int i = 0; i < numBalls; i++ )
		ball[ i ].Accel();
}

//
//	This draws the background bitmap
//

BOOL DrawBackground( BYTE back_color, LPDIRECTDRAWSURFACE pPatSurf,
					 const DDSURFACEDESC& ddsd )
{

	BYTE* pBits;

	if ( pPatSurf->IsLost() )
		if ( !CreateCheckerSurface() )
			return FALSE;

	//
	//	make sure any other asynchronous blits have finished
	//

	if ( !WaitForBltDone( pBackgSurface ) )
		return DIAGNOSE;

	DDTRACE << pBackgSurface << " DirectDrawSurface::Lock()\n";

	sCode = pBackgSurface->Lock( NULL, &ddBackgSurfDesc,
								 DDLOCK_SURFACEMEMORYPTR, NULL );

    CHECK;

	pBits = (BYTE*)ddBackgSurfDesc.lpSurface;

	if ( pBits )
		memset( pBits, back_color, uWidth * uHeight );

	DDTRACE << pBackgSurface << " DirectDrawSurface::Unlock()\n";

	sCode = pBackgSurface->Unlock( pBits );

	if ( sCode != DDERR_GENERIC )			// cirrus bug
	{
		CHECK;
	}

	//
	//	tile across the background bitmap
	//

	RECT rc = { 0, 0, ddsd.dwWidth, ddsd.dwHeight };

	for ( UINT y = 0; y < uHeight; y += rc.bottom )
		for ( UINT x = 0; x < uWidth; x += rc.right )
		{

			RECT rcSrc  = { 0, 0, min( rc.right, (LONG)( uWidth - x ) ),
							min( rc.bottom, (LONG)( uHeight - y ) ) };

			sCode = pBackgSurface->BltFast( x, y, pPatSurf, &rcSrc, TRUE );

            CHECK;

		}

	return TRUE;

}

BOOL ShowImage( void )
{

	DWORD s = timeGetTime();

	if ( page_flip )
	{

		DDTRACE << pFlipSurface << " DirectDrawSurface::Flip()\n";

		do
		{
			sCode = pFlipSurface->Flip( NULL, 0 );
		}
        while ( sCode == DDERR_WASSTILLDRAWING );

	}
	else
	{

		DDTRACE << pPrimarySurface << " DirectDrawSurface::BltFast()\n";

		if ( !WaitForBltOk( pPrimarySurface ) )
        	DIAGNOSE;

		sCode = pPrimarySurface->BltFast( 0,
										  0,
										  pOffSurface,
										  NULL,
										  FALSE );

		if ( numBackBuffs > 1 )
        	swap( pOffSurface, pOffSurface2 );

	}

	DDTRACE << ( timeGetTime() - s ) << " ms in ShowImage()\n";

	CHECK;

	frame++;

	return SUCCEEDED( sCode );

}

BOOL ComposeAndShowImage( void )
{
	if ( start == 0 )
		start = timeGetTime();
	if ( ComposeImage() && ShowImage() )
	{
		end = timeGetTime();
		DDTRACE << frame << " frames.\n";
		DDTRACE << ( frame * 1000 / ( end - start ) ) << " fps.\n";
		return TRUE;
	}
	return FALSE;
}



